@extends('templates.layout-main')
@section('content')
    <style>
        .table-responsive {
            max-height: 400px;
            overflow-y: auto;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            padding: 8px;
            text-align: left;
            border: 1px solid #ddd;
        }

        thead th {
            position: -webkit-sticky;
            position: sticky;
            top: 0;
            background: #f1f1f1;
            z-index: 1;
        }
    </style>

    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="row">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <td><b>Mapping No : </b></td>
                                            <td>{{ $data->mapping_no }}</td>
                                            <td><b>Branch : </b></td>
                                            <td>{{ $data->branchName }}</td>
                                        </tr>
                                        <tr>
                                            <td><b>Date : </b></td>
                                            <td>{{ $data->date }}</td>
                                            <td><b>Created User : </b></td>
                                            <td>{{ $data->createdUser }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            <div class="row table-responsive">
                                <h3>Mapping Details</h3>
                                <table class="table table-bordered">
                                    <thead>
                                        <tr>
                                            <th>S.No</th>
                                            <th>Agent</th>
                                            <th>Customer</th>
                                            <th>Mobile</th>
                                            <th>Description</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($data->items as $key => $item)
                                            <tr>
                                                <td>{{ $key + 1 }}</td>
                                                <td>{{ $item->agentName }}</td>
                                                <td>{{ $item->customer_name }}</td>
                                                <td>{{ $item->mobile_number }}</td>
                                                <td>{{ $item->description }}</td>
                                            </tr>
                                        @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
@endsection
