@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-wrap">

                                <div class="row">
                                    <div class="col-md-12">
                                        @isset($data->transcript)
                                            <div class="mt-3">
                                                <h3>Audio Transcript</h3>
                                                @foreach ($data->transcript->audio_transcript as $key => $item)
                                                    @foreach ($item as $conversation)
                                                        <p><b style="color: #fff;">{{ $conversation->speaker }}:
                                                            </b>{{ $conversation->text }}
                                                        </p>
                                                    @endforeach
                                                @endforeach
                                            </div>
                                            <div class="mt-3">
                                                <h3>Script Converage</h3>
                                                @foreach ($data->transcript->script_coverage->sections as $key => $item)
                                                    <p>
                                                    <h5 style="color: #fff;">{{ pascalCase($key) }}</h5>
                                                    <b style="color: #fff;">Covered : </b>{{ $item->covered }}<br>
                                                    <b style="color: #fff;">Missing Keywords : </b>
                                                    @if (!empty($item->missing_keywords))
                                                        {{ implode(', ', $item->missing_keywords) }}
                                                    @endif
                                                    <br>
                                                    <b style="color: #fff;">Actionable Insights :
                                                    </b>{{ $item->actionable_insights }}
                                                    </p>
                                                @endforeach
                                            </div>
                                            <div class="mt-3">
                                                <h3>Overall Converage</h3>
                                                <p><b style="color: #fff;">Percentage :
                                                    </b>{{ $data->transcript->script_coverage->overall_coverage->percentage }}
                                                </p>
                                                <p><b style="color: #fff;">Sections Covered :
                                                    </b>{{ $data->transcript->script_coverage->overall_coverage->sections_covered }}
                                                </p>
                                                <p><b style="color: #fff;">Sections Partially Covered :
                                                    </b>{{ $data->transcript->script_coverage->overall_coverage->sections_partially_covered }}
                                                </p>
                                                <p><b style="color: #fff;">Sections Missed :
                                                    </b>{{ $data->transcript->script_coverage->overall_coverage->sections_missed }}
                                                </p>
                                                <p><b style="color: #fff;">Actionable Insights :
                                                    </b>
                                                    @if (!empty($data->transcript->script_coverage->overall_coverage->actionable_insights))
                                                        {{ implode(', ', $data->transcript->script_coverage->overall_coverage->actionable_insights) }}
                                                    @endif
                                                </p>
                                            </div>
                                        @endisset
                                    </div>
                                </div>

                                <div class="form-group row justify-content-end mt-3 mb-0">
                                    <div class="col-md-8 pl-md-2">
                                        <a href="{{ $data->breadcrumbAction }}"
                                            class="btn ripple btn-secondary pd-x-30">Back to List</a>
                                    </div>
                                </div>

                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('footerScripts')
@endsection
