@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection

@section('content')
    <style>
        .dark-theme .nav-tabs .nav-link {
            font-size: 12px;
        }
    </style>
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports', [
                'export' => true,
                'class' => 'downloadReport',
            ])

            @include('report_filters', [
                'branch' => true,
                'month' => true,
                'year' => true,
            ])
            <button class="btn btn-success getReport">Get Report</button>
            <div class="row row-sm mt-3">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div id="reportTblBody"></div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    <script>
        $(document).on('click', '.getReport', function() {
            getReport();
        });

        $(document).on("click", ".downloadReport", function() {
            var input = $("<input>")
                .attr("type", "hidden")
                .attr("name", "type")
                .val("sales-analysis-report-excel");
            $("#report-form").append(input);
            $("#report-form").submit();
        });

        function getReport() {
            showLoader();
            $('#reportTblBody').empty();
            var formData = {
                branch: $('#branch').val(),
                years: $('#years').val(),
                months: $('#months').val(),
            }
            $.ajax({
                url: "{{ route('getSalesAnalysisData') }}",
                type: "POST",
                data: formData,
                dataType: "json",
                headers: {
                    "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
                },
                success: function(response) {
                    $('#reportTblBody').html(response.html);
                    hideLoader();
                },
                error: function(jqXHR, exception) {
                    hideLoader();
                },
            });
        }
        getReport();
    </script>
@endsection
