<div class="table-responsive border">
    <table class="table text-nowrap text-md-nowrap table-bordered mg-b-0" style="width: 100%">
        <thead>
            <tr>
                <th class="wd-5p text-center">Sales Analysis</th>
                @foreach ($result->tableHeader as $header)
                    <th class="wd-20p text-center">{{ $header }}</th>
                @endforeach
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="text-center">Sales Converted On Connected Calls</td>
                @foreach ($result->tableOne as $tblOneRow)
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblOneRow->salesConvOnConnCalls) }}</td>
                @endforeach
            </tr>
            <tr>
                <td class="text-center">Total Allocated Calls</td>
                @foreach ($result->tableOne as $tblOneRow)
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblOneRow->allocatedCalls) }}</td>
                @endforeach
            </tr>
            <tr>
                <td class="text-center">Connected Calls Ratio %</td>
                @foreach ($result->tableOne as $tblOneRow)
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblOneRow->connCallRatio) }} %</td>
                @endforeach
            </tr>
            <tr>
                <td class="text-center">If Connected Calls With Total Allocated</td>
                @foreach ($result->tableOne as $tblOneRow)
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblOneRow->connTotalAll) }}</td>
                @endforeach
            </tr>
            <tr>
                <td class="text-center">Same Sales Conversion On Allocated</td>
                @foreach ($result->tableOne as $tblOneRow)
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblOneRow->salesConversion) }}</td>
                @endforeach
            </tr>
            <tr>
                <td class="text-center">Average Sales Price</td>
                @foreach ($result->tableOne as $tblOneRow)
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblOneRow->avgSalesPrice) }}</td>
                @endforeach
            </tr>
            <tr>
                <td class="text-center">If Sales Converted On Allocated Calls</td>
                @foreach ($result->tableOne as $tblOneRow)
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblOneRow->salesConvertedAllocatedCalls) }}
                    </td>
                @endforeach
            </tr>
        </tbody>
    </table>
</div>
<div class="mt-3">
    <h6 class="main-content-label mb-1">Last 2 Months</h6>
</div>
<div class="table-responsive border mt-3">
    <table class="table text-nowrap text-md-nowrap table-bordered mg-b-0" style="width: 100%">
        <thead>
            <tr>
                <th class="wd-5p">Last 2 Months</th>
                <th class="wd-20p text-center" colspan="2">
                    @foreach ($result->tableHeader as $index => $header)
                        {{ $header }} @if ($index !== count($result->tableHeader) - 1)
                            &
                        @endif
                    @endforeach
                </th>
                @foreach ($result->tableHeader as $header)
                    <th class="wd-20p text-center" colspan="2">{{ $header }}</th>
                @endforeach
            </tr>
            <tr>
                <th class="wd-5p text-center">Conversions</th>
                <th class="wd-20p text-center">Sales Qty</th>
                <th class="wd-20p text-center">Sales Value</th>
                <th class="wd-20p text-center">Sales Qty</th>
                <th class="wd-20p text-center">Sales Value</th>
                <th class="wd-20p text-center">Sales Qty</th>
                <th class="wd-20p text-center">Sales Value</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="text-center">Total Sales</td>
                @foreach ($result->tableTwo as $tblTwoRow)
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblTwoRow->totalSales->qty) }}
                    </td>
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblTwoRow->totalSales->value) }}
                    </td>
                @endforeach
            </tr>
            <tr>
                <td class="text-center">Connected Calls</td>
                @foreach ($result->tableTwo as $tblTwoRow)
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblTwoRow->connCalls->qty) }}
                    </td>
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblTwoRow->connCalls->value) }}
                    </td>
                @endforeach
            </tr>
            <tr>
                <td class="text-center">Not Connected</td>
                @foreach ($result->tableTwo as $tblTwoRow)
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblTwoRow->notConnCalls->qty) }}
                    </td>
                    <td class="text-center">{{ returnZeroWhenEmptyOrNull($tblTwoRow->notConnCalls->value) }}
                    </td>
                @endforeach
            </tr>
        </tbody>
    </table>
</div>
