@foreach ($data as $scheme)
    <div class="col-lg-12">
        <hr>
        <h4>{{ $scheme->schemeName }} - {{ $scheme->programName }} - ({{ $scheme->feedbackCount }})</h4>
        <hr>
    </div>
    @foreach ($scheme->questions as $questions)
        <div class="col-md-3">
            <div class="card custom-card">
                <div class="card-header p-3 tx-medium my-auto tx-white {{ $questions->class }}">
                    {!! removeHtmlTags($questions->label) !!}
                </div>
                <div class="card-body">
                    <div class="row">
                        @if (isset($questions->answers) && count($questions->answers) > 0)
                            @foreach ($questions->answers as $answers)
                                <div class="col-md-8">{!! removeHtmlTags($answers->label) !!}</div>
                                <div class="col-md-4"><a href="javascript:void(0)" class="programwise-details" data-scheme="{{ $scheme->schemeId }}" data-program="{{ $scheme->programId }}" data-question="{{ $questions->name }}" data-answer="{{ removeHtmlTags($answers->label) }}" data-ques-label="{{ removeHtmlTags($questions->label) }}" data-others="{{ isset($answers->others) ? $answers->others : false }}">
                                        {{ $answers->count }} - ({{ $answers->percentage . ' %' }}) </a></div>
                            @endforeach
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endforeach
@endforeach
