@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="row row-sm">
            <div class="col-lg-12">
                @include('reports.report_filters-label')
            </div>
            <div class="col-lg-12">
                <div class="card-body">
                    <div id="districtwise-report-content"></div>
                </div>
            </div>
            <div class="col-lg-12">
                <button class="btn btn-success btn-icon-text my-2 mr-2 pull-right downloadExcelDetails"
                    data-question="{{ isset($data->question) ? $data->question : '' }}"
                    data-answer="{{ isset($data->answer) ? $data->answer : '' }}"
                    data-others="{{ isset($data->others) ? $data->others : '' }}">
                    <i class="fe fe-download mr-2"></i> Excel
                </button>
            </div>
        </div>
        <div class="inner-body">
            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table dashboard-datatable" id="dashboard-datatable">
                                    <thead>
                                        <tr>
                                            <th class="wd-10p">Action</th>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-10p">Call At</th>
                                            <th class="wd-5p">Recordings</th>
                                            <th class="wd-10p">Feedback ID</th>
                                            <th class="wd-10p">Ben Name</th>
                                            <th class="wd-10p">Mobile</th>
                                            <th class="wd-10p">Scheme</th>
                                            <th class="wd-10p">Program</th>
                                            <th class="wd-10p">District</th>
                                            <th class="wd-10p">Block</th>
                                            <th class="wd-10p">Sector</th>
                                            <th class="wd-10p">AWC</th>
                                            <th class="wd-10p">Complaint <br>Registered</th>
                                            <th class="wd-10p">Call By</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/programwise-report.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {
            var table = $('.dashboard-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('programwise-report-detailed') }}",
                    data: function(d) {
                        d.scheme = $('#scheme').val(),
                            d.program = $('#program').val(),
                            d.district = $('#district').val(),
                            d.block = $('#block').val(),
                            d.fromDate = $('#fromDate').val(),
                            d.toDate = $('#toDate').val(),
                            d.answer = $('#answer').val(),
                            d.others = $('#others').val(),
                            d.question = $('#question').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'dateTime',
                        name: 'feedback.created_at'
                    },
                    {
                        data: 'downloadRecordings',
                        name: 'downloadRecordings',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'feedback_no',
                        name: 'feedback.feedback_no'
                    },
                    {
                        data: 'parent_name',
                        name: 'parent_name'
                    },
                    {
                        data: 'mobile_number',
                        name: 'mobile_number'
                    },
                    {
                        data: 'scheme',
                        name: 'scheme_master.name'
                    },
                    {
                        data: 'program',
                        name: 'program_master.name'
                    },
                    {
                        data: 'district',
                        name: 'city_master.name'
                    },
                    {
                        data: 'block',
                        name: 'block_master.name'
                    },
                    {
                        data: 'sector_name',
                        name: 'sector_master.name'
                    },
                    {
                        data: 'awc_name',
                        name: 'awc_master.name'
                    },
                    {
                        data: 'complaint_registered',
                        name: 'complaint_registered',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'call_user',
                        name: 'users.name'
                    },


                ]
            });

        });
    </script>
@endsection
