<!-- Main Content-->
@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.high-charts')
    @include('templates.datatable-style')
    <link rel="stylesheet" href="{{ URL::asset('css/spinner.css') }}?{{ appVersion() }}" type="text/css" />
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">
            @include('dashboard-filters')
            <div class="loading" id="global-loader-1">Loading&#8230;</div>
            <div id="dashboard-content"></div>
            <div class="loading" id="global-loader-2">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="answered-comparision-chart"></div>
            </figure>
            <div class="loading" id="global-loader-3">Loading&#8230;</div>
            <div id="programwise-calls"></div>
            <div class="loading" id="global-loader-4">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="programwise-chart"></div>
            </figure>
            <div class="loading" id="global-loader-5">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="programwise-chart-percentage"></div>
            </figure>
            <div class="loading" id="global-loader-6">Loading&#8230;</div>
            <div id="separte-programwise-calls"></div>
            <div class="loading" id="global-loader-7">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="districtwise-chart"></div>
            </figure>
            <div class="loading" id="global-loader-8">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="maximum-feedback-chart"></div>
            </figure>
            <div class="loading" id="global-loader-9">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="maximum-feedback-chart-percentage"></div>
            </figure>
            <div class="loading" id="global-loader-10">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="maximum-complaints-chart"></div>
            </figure>
            <div class="loading" id="global-loader-11">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="maximum-complaints-chart-percentage"></div>
            </figure>
            <div class="loading" id="global-loader-12">Loading&#8230;</div>
            <div id="high-complaints-program-wise"></div>
            <div class="loading" id="global-loader-13">Loading&#8230;</div>
            <div id="categorywise-complaints"></div>
            <div class="loading" id="global-loader-14">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="top-complaints-districts"></div>
            </figure>
            <div class="loading" id="global-loader-15">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="top-complaints-districts-percentage"></div>
            </figure>
            <div class="loading" id="global-loader-16">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="max-wrong-numbers"></div>
            </figure>
            <div class="loading" id="global-loader-17">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="max-wrong-numbers-percentage"></div>
            </figure>
            <div class="loading" id="global-loader-18">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="not-attend"></div>
            </figure>
            <div class="loading" id="global-loader-19">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="not-attend-percentage"></div>
            </figure>
            <div class="loading" id="global-loader-20">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="resolved-charts"></div>
            </figure>
            <div class="loading" id="global-loader-21">Loading&#8230;</div>
            <figure class="highcharts-figure">
                <div id="resolved-charts-percentage"></div>
            </figure>
            <div class="loading" id="global-loader-22">Loading&#8230;</div>
            <div class="row row-sm">
                <div class="col-md-12"><label class="main-content-label mb-3 pt-1">Resolved List</label></div>
                <div class="col-md-6" id="resolved_list">
                </div>
            </div>
            <div class="loading" id="global-loader-23">Loading&#8230;</div>
            <figure class="highcharts-figure mt-3">
                <div id="reconnected-charts"></div>
            </figure>
            <div class="loading" id="global-loader-24">Loading&#8230;</div>
            <figure class="highcharts-figure mt-3">
                <div id="reconnected-charts-percentage"></div>
            </figure>
            <div class="loading" id="global-loader-25">Loading&#8230;</div>
            <div class="row row-sm">
                <div class="col-md-12"><label class="main-content-label mb-3 pt-1">Reconnect List</label></div>
                <div class="col-md-6" id="reconnect_list">
                </div>
            </div>
            <div class="loading" id="global-loader-26">Loading&#8230;</div>
            <figure class="highcharts-figure mt-3">
                <div id="complaints-comparision"></div>
            </figure>
            <div class="loading" id="global-loader-27">Loading&#8230;</div>
            <div class="row row-sm">
                <div class="col-md-12"><label class="main-content-label mb-3 pt-1">Complaints List</label></div>
                <div class="col-md-6" id="complaints_list">
                </div>
            </div>
            <div class="loading" id="global-loader-28">Loading&#8230;</div>
            <figure class="highcharts-figure mt-3">
                <div id="feedback-comparision"></div>
            </figure>
            <div class="loading" id="global-loader-29">Loading&#8230;</div>
            <div class="row row-sm">
                <div class="col-md-12"><label class="main-content-label mb-3 pt-1">Feedback List</label></div>
                <div class="col-md-6" id="feedback_list">
                </div>
            </div>
            <div class="loading" id="global-loader-30">Loading&#8230;</div>
            <div id="esc-dashboard-content" class="mt-3"></div>
            <div class="loading" id="global-loader-31">Loading&#8230;</div>
            <figure class="highcharts-figure mt-3">
                <div id="complaints-resolved-by-worker"></div>
            </figure>
            <div class="loading" id="global-loader-32">Loading&#8230;</div>
            <div class="row row-sm">
                <div class="col-md-12"><label class="main-content-label mb-3 pt-1">Districtwise Avg Time To
                        Resolve</label>
                </div>
                <div class="col-md-6" id="districtwise-avg-time-resolved">
                </div>
            </div>
        </div>
    </div>
    <!-- End Main Content-->
@endsection
@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/presentation.js') }}?{{ appVersion() }}"></script>
@endsection
