@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">

        <div class="inner-body">
            <form name="report-form" id="report-form" method="POST" action="{{ $data->route }}">
                @csrf
                @method('POST')
                <input type="hidden" name="fromDate" id="fromDate"
                    value="{{ isset($data->fromDate) ? $data->fromDate : '' }}">
                <input type="hidden" name="toDate" id="toDate" value="{{ isset($data->toDate) ? $data->toDate : '' }}">
                <input type="hidden" name="scheme" id="scheme" value="{{ isset($data->scheme) ? $data->scheme : '' }}">
                <input type="hidden" name="program" id="program"
                    value="{{ isset($data->program) ? $data->program : '' }}">
                <input type="hidden" name="district" id="district"
                    value="{{ isset($data->district) ? $data->district : '' }}">
                <input type="hidden" name="block" id="block" value="{{ isset($data->block) ? $data->block : '' }}">
                <input type="hidden" name="refId" id="refId" value="{{ isset($data->refId) ? $data->refId : '' }}">
                <input type="hidden" name="fieldType" id="fieldType" value="{{ isset($data->fieldType) ? $data->fieldType : '' }}">

                <div class="row row-sm">
                    <div class="col-md-12">
                        <button class="btn btn-success btn-icon-text my-2 mr-2 pull-right downloadExcelEscDashboard">
                            <i class="fe fe-download mr-2"></i> Excel
                        </button>
                    </div>
                </div>
            </form>
            <div class="row row-sm">
                <div class="col-lg-12">
                    <div class="card custom-card overflow-hidden">
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table dashboard-datatable custom-dt-style" id="dashboard-datatable">
                                    <thead>
                                        <tr>
                                            <th class="wd-10p">Action</th>
                                            <th class="wd-5p">S.No</th>
                                            <th class="wd-20p">Feedback No</th>
                                            <th class="wd-20p">Ben Name</th>
                                            <th class="wd-20p">Mobile</th>
                                            <th class="wd-20p">Call Date</th>
                                            <th class="wd-20p">Call By</th>
                                            <th class="wd-20p">Scheme</th>
                                            <th class="wd-20p">Program</th>
                                            <th class="wd-20p">District</th>
                                            <th class="wd-20p">Block</th>
                                            <th class="wd-20p">AWC</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@include('transactions.resolve-model')
@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/list_page.js') }}?{{ appVersion() }}"></script>
    <script type="text/javascript">
        $(function() {
            var table = $('.dashboard-datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: {
                    url: "{{ route('dashboard.detailedReportAjax') }}",
                    data: function(d) {
                        d.scheme = $('#scheme').val(),
                            d.program = $('#program').val(),
                            d.district = $('#district').val(),
                            d.block = $('#block').val(),
                            d.fromDate = $('#fromDate').val(),
                            d.toDate = $('#toDate').val(),
                            d.fieldType = $('#fieldType').val(),
                            d.refId = $('#refId').val()
                    }
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                columns: [{
                        data: 'action',
                        name: 'action',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'DT_RowIndex',
                        name: 'DT_RowIndex',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'feedback_no',
                        name: 'feedback.feedback_no'
                    },
                    {
                        data: 'parent_name',
                        name: 'beneficiary_import.parent_name'
                    },
                    {
                        data: 'mobile_number',
                        name: 'beneficiary_import.mobile_number'
                    },
                    {
                        data: 'dateTime',
                        name: 'dateTime',
                        orderable: false,
                        searchable: false
                    },
                    {
                        data: 'created_user',
                        name: 'users.name'
                    },
                    {
                        data: 'scheme_name',
                        name: 'scheme_master.name'
                    },
                    {
                        data: 'program_name',
                        name: 'program_master.name'
                    },
                    {
                        data: 'district_name',
                        name: 'city_master.name'
                    },
                    {
                        data: 'block_name',
                        name: 'block_master.name'
                    },
                    {
                        data: 'awc_name',
                        name: 'awc_master.name'
                    }
                ]

            });

            $(".downloadExcel").on('click', function(e) {
                e.preventDefault();
                $('#report-form').submit();
            });

        });
    </script>
@endsection
