@extends('templates.layout-main')
<style>
    .dataTable-col-numbers {
        width: 50px !important;
        word-wrap: break-word !important;
    }
</style>
@section('HeaderScripts')
    @include('templates.datatable-style')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb-reports')

            <form class="form-horizontal" name="report-form" id="report-form" action="" method="POST">
                @csrf
                @method('POST')
                <div class="row row-sm">
                    <div class="col-md-3">
                        <x-date-range />
                    </div>
                    <div class="col-md-3">
                        <x-agent-drop-down />
                    </div>
                    <div class="col-md-3">
                        <x-program-drop-down />
                    </div>

                    <div class="col-md-3">
                        <x-district-drop-down />
                    </div>

                    <div class="row col-md-6 mg-t-10">
                        <input type="hidden" name="type" id="type" value="daily-report">
                        <div class="col-lg-4">
                            <label class="rdiobox"><input checked name="shownBy" type="radio" value="Agentwise"
                                    class="common-on-change">
                                <span>Agentwise</span></label>
                        </div>
                        <div class="col-lg-4">
                            <label class="rdiobox"><input name="shownBy" type="radio" value="Programwise"
                                    class="common-on-change">
                                <span>Programwise</span></label>
                        </div>
                        <div class="col-lg-4">
                            <label class="rdiobox"><input name="shownBy" type="radio" value="Districtwise"
                                    class="common-on-change">
                                <span>Districtwise</span></label>
                        </div>
                    </div>
                </div>
            </form>
            <div id="report_content">

            </div>

        </div>
    </div>
@endsection

@section('footerScripts')
    @include('templates.datatable-scripts')
    <script src="{{ URL::asset('js/daily-report.js') }}?{{ appVersion() }}"></script>
@endsection
