<!-- Main Content-->
@extends('templates.layout-main')
@section('HeaderScripts')
    @include('templates.high-charts')
@endsection
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            <div class="mt-3">
                <div class="row row-sm">
                    <div class="col-md-3">
                        <label class="form-label">Date Range</label>
                        <x-date-range label="{{ false }}" />
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Cluster</label>
                        <x-cluster-drop-down label="{{ false }}" />
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Branch</label>
                        <x-branch-drop-down label="{{ false }}" />
                    </div>
                </div>
            </div>
            <div class="row row-sm">
                <div class="col-sm-12 col-md-6 col-lg-3 col-xl-3">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="card-order ">
                                <label class="main-content-label mb-3 pt-1">Organization Score</label>
                                <h2 class="text-right card-item-icon card-icon"><a href="#">
                                        <i class="fa fa-university icon-size float-left text-success"></i><span
                                            class="font-weight-bold" id="orgScore">
                                    </a>
                                </h2>
                                <span id="previousScore"></span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-6 col-lg-3 col-xl-3">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="card-order ">
                                <label class="main-content-label mb-3 pt-1">Total Agents</label>
                                <h2 class="text-right card-item-icon card-icon"><a href="#">
                                        <i class="fa fa-users icon-size float-left text-warning"></i><span
                                            class="font-weight-bold" id="agentsCount">
                                    </a>
                                </h2>
                                <p style="height:23px;"></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-6 col-lg-3 col-xl-3">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="card-order ">
                                <label class="main-content-label mb-3 pt-1">Total Calls</label>
                                <h2 class="text-right card-item-icon card-icon"><a href="#">
                                        <i class="fa fa-phone icon-size float-left text-danger"></i><span
                                            class="font-weight-bold" id="totalCalls">
                                    </a>
                                </h2>
                                <p style="height:23px;"></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12 col-md-6 col-lg-3 col-xl-3">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="card-order">
                                <label class="main-content-label mb-3 pt-1">Avg Handling Time</label>
                                <h2 class="text-right card-item-icon card-icon"><a href="#">
                                        <i class="fa fa-clock-o icon-size float-left text-info"></i><span
                                            class="font-weight-bold" id="avgHandling">
                                    </a>
                                </h2>
                                <p style="height:23px;"></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="text-wrap">
                        <div class="example">
                            <div class="bg-gray-300 nav-bg">
                                <nav class="nav nav-tabs">
                                    <a class="nav-link active" data-toggle="tab" href="#tabCont1">Overview</a>
                                    <a class="nav-link" data-toggle="tab" href="#tabCont2">Branch Analysis</a>
                                    <a class="nav-link" data-toggle="tab" href="#tabCont3">Agents</a>
                                </nav>
                            </div>

                            <div class="card-body tab-content">

                                <div class="tab-pane active show" id="tabCont1">
                                    <div class="row row-sm">

                                        <div class="col-md-8">
                                            <div class="card custom-card">
                                                <div class="card-body">
                                                    <div id="performance-trend"></div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4">
                                            <div id="overviewHtml"></div>
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane" id="tabCont2">
                                    <div class="row row-sm" id="branchAnalysisHtml">
                                    </div>
                                </div>
                                <div class="tab-pane" id="tabCont3">
                                    <div class="row row-sm" id="agent-table">
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End Main Content-->
@endsection
@section('footerScripts')
    <script src="{{ URL::asset('js/analytics-dashboard.js') }}?{{ appVersion() }}"></script>
@endsection
