@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div>
                                <h6 class="main-content-label mb-1">Privileges</h6>
                            </div>
                            <div aria-multiselectable="true" class="accordion accordion-color" id="accordion2" role="tablist">

                                @foreach ($data->list as $mkey => $menu)
                                    <div class="card">

                                        <div class="card-header" id="headingOne{{ $mkey }}" role="tab">
                                            <a aria-controls="collapseOne{{ $mkey }}" aria-expanded="false"
                                                data-toggle="collapse"
                                                href="#collapseOne{{ $mkey }}">{{ $menu->menu_name }}</a>
                                        </div>

                                        <div aria-labelledby="headingOne{{ $mkey }}" class="collapse show"
                                            data-parent="#accordion2" id="collapseOne{{ $mkey }}" role="tabpanel">
                                            <div class="card-body">
                                                <table
                                                    class="table card-table table-striped table-vcenter text-nowrap mb-0">
                                                    <thead>
                                                        <tr>
                                                            <th>Menu Name</th>
                                                            <th>Create</th>
                                                            <th>View</th>
                                                            <th>Print</th>
                                                            <th>Edit</th>
                                                            <th>Active</th>
                                                            <th>Inactive</th>
                                                            <th>Delete</th>
                                                            <th>Import</th>
                                                            <th>Export</th>
                                                            <th>Approve</th>
                                                            <th>Reject</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($menu->subMenu as $subKey => $subMenu)
                                                            <tr>
                                                                <td>{{ $subMenu->menu_name }}</td>
                                                                <td>@if($subMenu->create) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                                <td>@if($subMenu->view) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                                <td>@if($subMenu->print) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                                <td>@if($subMenu->edit) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                                <td>@if($subMenu->active) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                                <td>@if($subMenu->inactive) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                                <td>@if($subMenu->delete) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                                <td>@if($subMenu->import) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                                <td>@if($subMenu->export) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                                <td>@if($subMenu->approve) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                                <td>@if($subMenu->reject) <i class="fe fe-check-square privilege_icon"></i> @endif</td>
                                                            </tr>
                                                        @endforeach

                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                    </div>
                                @endforeach

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
@endsection
