@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="card custom-card">
                        <div class="card-body">

                            <div id="cloneDiv" data-prototype='@include('master.escalation.level-clone')'></div>

                            <form class="form-horizontal" name="escalation-form" id="escalation-form"
                                action="{{ $data->route }}" data-parsley-validate="" method="POST">
                                @csrf
                                @method($data->method)

                                <input type="hidden" value="{{ isset($data->id) ? $data->id : '' }}" id="uniqueId"
                                    name="uniqueId">

                                <div class="row row-sm">
                                    <div class="col-md-3">
                                        <x-scheme-drop-down selected="{{ $data->scheme_id }}" />
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="row row-sm">
                                                <div class="col-md-3">
                                                    <label class="form-label">Program</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <div class="parsley-select">
                                                        <select class="form-control select2 common-on-change" required=""
                                                            name="program" id="program"
                                                            data-parsley-required-message="Select Program"
                                                            data-parsley-class-handler="#program"
                                                            data-parsley-errors-container="#programErrorContainer">
                                                            <option label="Select Program">
                                                            </option>
                                                            @foreach ($data->programList as $program)
                                                                <option value="{{ $program->id }}"
                                                                    @if ($program->id == $data->program_id) {{ 'selected' }} @endif>
                                                                    {{ $program->name }}</option>
                                                            @endforeach
                                                        </select>
                                                        <div id="programErrorContainer"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-md-3">
                                        <x-district-drop-down selected="{{ $data->district_id }}" />
                                    </div>

                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="row row-sm">
                                                <div class="col-md-3">
                                                    <label class="form-label">Block</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <div class="parsley-select">
                                                        <select class="form-control select2 common-on-change" required=""
                                                            name="block" id="block"
                                                            data-parsley-required-message="Select Block"
                                                            data-parsley-class-handler="#block"
                                                            data-parsley-errors-container="#blockErrorContainer">
                                                            <option label="Select Block">
                                                            </option>
                                                            @foreach ($data->blockList as $block)
                                                                <option value="{{ $block->id }}"
                                                                    @if ($block->id == $data->block_id) {{ 'selected' }} @endif>
                                                                    {{ $block->name }}</option>
                                                            @endforeach
                                                        </select>
                                                        <div id="blockErrorContainer"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="row row-sm">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="row row-sm">
                                                <div class="col-md-3">
                                                    <label class="form-label">Sector</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <div class="parsley-select">
                                                        <select class="form-control select2 common-on-change" required=""
                                                            name="sector" id="sector"
                                                            data-parsley-required-message="Select Sector"
                                                            data-parsley-class-handler="#sector"
                                                            data-parsley-errors-container="#sectorErrorContainer">
                                                            <option label="Select Sector">
                                                            </option>
                                                            @foreach ($data->sectorList as $sector)
                                                                <option value="{{ $sector->id }}"
                                                                    @if ($sector->id == $data->sector_id) {{ 'selected' }} @endif>
                                                                    {{ $sector->name }}</option>
                                                            @endforeach
                                                        </select>
                                                        <div id="sectorErrorContainer"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <div class="row row-sm">
                                                <div class="col-md-3">
                                                    <label class="form-label">AWC</label>
                                                </div>
                                                <div class="col-md-9">
                                                    <div class="parsley-select">
                                                        <select class="form-control select2 common-on-change" required=""
                                                            name="awc" id="awc"
                                                            data-parsley-required-message="Select AWC"
                                                            data-parsley-class-handler="#awc"
                                                            data-parsley-errors-container="#awcErrorContainer">
                                                            <option label="Select AWC">
                                                            </option>
                                                            @foreach ($data->awcList as $awc)
                                                                <option value="{{ $awc->id }}"
                                                                    @if ($awc->id == $data->awc_id) {{ 'selected' }} @endif>
                                                                    {{ $awc->name }} - {{ $awc->code }}</option>
                                                            @endforeach
                                                        </select>
                                                        <div id="awcErrorContainer"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="row row-sm">
                                    <table class="table table-borderd" id="levels-table">
                                        <thead>
                                            <tr>
                                                <th>Level</th>
                                                <th>Name</th>
                                                <th>Mobile</th>
                                                <th>Email</th>
                                                <th>District</th>
                                                <th>Esc.Days</th>
                                                {{-- <th>Resolving<br> Officer</th> --}}
                                                <th>
                                                    <a class="btn ripple btn-success btn-sm add-row">
                                                        <i class="fe fe-plus"></i> Add Row
                                                    </a>
                                                </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach ($data->escLevels as $key => $level)
                                                @include('master.escalation.level-clone', [
                                                    'key' => $key + 1,
                                                    'level' => $level,
                                                ])
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script src="{{ URL::asset('js/masters/escalation.js') }}?{{ appVersion() }}"></script>
@endsection
