@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')
            <input type="hidden" id="getSalesDetailsUrl" value="{{ route('getSalesDetails') }}">
            <input type="hidden" id="getSubDeptUrl" value="{{ route('getSubDept') }}">

            <form class="form-horizontal" name="tickets-form" id="tickets-form" action="{{ $data->route }}"
                data-parsley-validate="" method="POST" enctype="multipart/form-data">
                @csrf
                @method($data->method)

                <div class="card custom-card">
                    <div class="card-body">
                        <div class="row row-sm">

                            <div class="col-lg-6 col-md-6">
                                <input type="hidden" id="submitType" name="submitType">
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Registered Mobile No</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="number" name="registerMobile" id="registerMobile"
                                                class="form-control" value="{{ $data->mobile }}" required=""
                                                data-parsley-required-message="Registered Mobile No is required">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Secondary Mobile No</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="number" name="secondaryMobile" class="form-control"
                                                value="{{ $data->secondary_mobile }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Customer Name</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="customerName" id="customerName" class="form-control"
                                                value="{{ $data->customer_name }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Email Address</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="email" name="customerEmail" class="form-control"
                                                value="{{ $data->email }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Location</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="location" class="form-control"
                                                value="{{ $data->location }}">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Address</label>
                                        </div>
                                        <div class="col-md-9">
                                            <textarea class="form-control" name="address" rows="3">{{ $data->address }}</textarea>
                                        </div>
                                    </div>
                                </div>
                                <x-product-drop-down selected="{{ $data->product_enquiry }}" />

                                {{-- <x-request-category-drop-down selected="{{ $data->request_category }}" />

                                <div class="col-md-12 text-center">
                                    <p>OR</p>
                                </div> --}}

                                <x-branch-drop-down selected="{{ $data->branch_id }}" />

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Sub Department</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select">
                                                <select class="form-control select2" name="subDepartment"
                                                    id="subDepartment">
                                                    @foreach ($data->subDeptList as $dept)
                                                        <option value="{{ $dept->id }}"
                                                            @if ($dept->id == $data->department) {{ 'selected' }} @endif>
                                                            {{ $dept->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <x-ticket-category-drop-down selected="{{ $data->ticket_category }}" />

                            </div>

                            <div class="col-lg-6 col-md-6">

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Users</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select">
                                                <select class="form-control select2" name="users" id="users">
                                                    @foreach ($data->usersList as $user)
                                                        <option value="{{ $user->id }}"
                                                            @if ($user->id == $data->users) {{ 'selected' }} @endif>
                                                            {{ $user->name }} - {{ $user->designation }} - {{ $user->class }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <x-ticket-source-drop-down selected="{{ $data->ticket_source }}" />

                                <x-ticket-type-drop-down selected="{{ $data->ticket_type }}" />

                                <x-priority-drop-down selected="{{ $data->priority }}" />

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Expected Date</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="mg-b-20">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <div class="input-group-text">
                                                            <i class="fe fe-calendar lh--9 op-6"></i>
                                                        </div>
                                                    </div><input class="form-control fc-datepicker-custom" type="text"
                                                        name="expectedDate" value="{{ $data->expected_date }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @if($data->id)
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Ticket Status</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="parsley-select">
                                                <select class="form-control select2" name="ticket_status" id="ticket_status">
                                                    @foreach ($data->statusList as $status)
                                                        <option value="{{ $status->id }}"
                                                            @if ($status->id == ($data->status == 'close_tickets' ? 3 : ($data->status == 'wip' ? 2 : 1))) selected @endif>
                                                            {{ $status->name }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endif
                                <div class="form-group" id="reason-div" style="display: none;">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Reason</label>
                                        </div>
                                        <div class="col-md-9">
                                            <select class="form-control select2" name="close_reason" id="close_reason">
                                                <option value="">Select Reason</option>
                                                @foreach ($data->reasonList as $reason)
                                                    <option value="{{ $reason->id }}"
                                                        @if ($reason->id == $data->reason) selected @endif>
                                                        {{ $reason->name }}
                                                    </option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                </div>                              
                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Expected Price</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="number" name="expectedPrice" class="form-control"
                                                value="{{ $data->expected_price }}">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Offer Price</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="number" name="offerPrice" class="form-control"
                                                value="{{ $data->offer_price }}">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Attachments</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="input-group file-browser">
                                                <input type="text" class="form-control border-right-0 browse-file"
                                                    placeholder="" readonly>
                                                <label class="input-group-btn">
                                                    <span class="btn btn-primary">
                                                        Browse <input type="file" name="attachments"
                                                            style="display: none;">
                                                    </span>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Comments</label>
                                        </div>
                                        <div class="col-md-9">
                                            <textarea class="form-control" name="comments" rows="3">{{ $data->ticket_comment }}</textarea>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="row row-sm">
                                <div class="col-md-12">
                                    <a class="btn ripple btn-danger" href="{{ route('tickets.index') }}">
                                        <i class="fe fe-arrow-left"></i> Back
                                    </a>
                                    <a class="btn ripple btn-primary" href="{{ route('tickets.create') }}">
                                        <i class="fe fe-trash"></i> Cancel
                                    </a>
                                    <button class="btn ripple btn-warning submit" type="button" data-type="draft">
                                        <i class="fe fe-edit"></i> Draft
                                    </button>
                                    <button class="btn ripple btn-success submit" type="button" data-type="submit">
                                        @if (isset($data->id))
                                            <i class="fe fe-edit"></i> Update
                                        @else
                                            <i class="fe fe-check-circle"></i> Submit
                                        @endif
                                    </button>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script src="{{ URL::asset('js/tickets.js') }}?{{ appVersion() }}"></script>
@endsection
