@extends('templates.layout-main')
@section('content')
    <div class="container-fluid">
        <div class="inner-body">

            @include('templates.breadcrumb')

            <div class="row row-sm">
                <div class="col-lg-12 col-md-12">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div id="cloneDiv" data-prototype='@include('campaign.voucher-clone')'>
                            </div>
                            <form class="form-horizontal" name="referral-form" id="referral-form" action="{{ $data->route }}"
                                data-parsley-validate="" method="POST" enctype="multipart/form-data">
                                @csrf
                                @method($data->method)

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Name</label>
                                        </div>
                                        <div class="col-md-9">
                                            <input type="text" name="name" class="form-control"
                                                value="{{ $data->name }}" required=""
                                                data-parsley-required-message="Name is required">
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Campaign Validity</label>
                                        </div>

                                        <div class="col-md-9">
                                            <div class="mg-b-20">
                                                <div class="input-group">
                                                    <div class="input-group-prepend">
                                                        <div class="input-group-text">
                                                            <i class="fe fe-calendar lh--9 op-6"></i>
                                                        </div>
                                                    </div><input class="form-control fc-datepicker-custom common-on-change"
                                                        type="text" name="campaignValidity" id="campaignValidity"
                                                        value="{{ $data->campaign_validity ? $data->campaign_validity : date('m/d/Y') }}">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Voucher Type</label>
                                        </div>
                                        <div class="col-md-9">
                                            Import
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Referrer</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <label class="form-label">Get Voucher</label>
                                                    <select class="form-control select2" required="" name="referrerGet"
                                                        id="referrerGet" data-parsley-required-message="Select"
                                                        data-parsley-class-handler="#referrerGet"
                                                        data-parsley-errors-container="#referrerGetErrorContainer">
                                                        @for ($i = 1; $i <= 10; $i++)
                                                            <option value="{{ $i }}"
                                                                @if ($i == $data->referrer_get) {{ 'selected' }} @endif>
                                                                GET {{ $i }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                    <div id="referrerGetErrorContainer"></div>
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="form-label">Purchase Value</label>
                                                    <input type="number" name="referrerValue" class="form-control"
                                                        value="{{ $data->referrer_value }}" required=""
                                                        data-parsley-required-message="Value is required">
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="form-label">Beneficiary Voucher Value</label>
                                                    <input type="number" name="beneficiaryValue" class="form-control"
                                                        value="{{ $data->beneficiary_value }}" required=""
                                                        data-parsley-required-message="Voucher Value is required">
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="form-label">Redeem From & To Date</label>
                                                    <div class="mg-b-20">
                                                        <div class="input-group">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text">
                                                                    <i class="fe fe-calendar lh--9 op-6"></i>
                                                                </div>
                                                            </div><input class="form-control date_range_only" type="text"
                                                                name="referrerFromTo" value="{{ $data->referrer_from_to }}">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">After Referral Referrer get</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="row" id="referralTxtBox">
                                                @if ($data->items)
                                                    @foreach ($data->items as $item)
                                                        @include('campaign.voucher-clone', [
                                                            'item' => $item,
                                                        ])
                                                    @endforeach
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                {{-- <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">
                                            <label class="form-label">Beneficiary</label>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="row">
                                                <div class="col-md-3">
                                                    <label class="form-label">Get</label>
                                                    <select class="form-control select2" required=""
                                                        name="beneficiaryGet" id="beneficiaryGet"
                                                        data-parsley-required-message="Select"
                                                        data-parsley-class-handler="#beneficiaryGet"
                                                        data-parsley-errors-container="#beneficiaryGetErrorContainer">
                                                        @for ($i = 1; $i <= 10; $i++)
                                                            <option value="{{ $i }}"
                                                                @if ($i == $data->beneficiary_get) {{ 'selected' }} @endif>
                                                                GET {{ $i }}
                                                            </option>
                                                        @endfor
                                                    </select>
                                                    <div id="beneficiaryGetErrorContainer"></div>
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="form-label">Value</label>
                                                    <input type="number" name="beneficiaryValue" class="form-control"
                                                        value="{{ $data->beneficiary_value }}" required=""
                                                        data-parsley-required-message="Value is required">
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="form-label">Voucher Value</label>
                                                    <input type="number" name="beneficiaryVoucherValue"
                                                        class="form-control"
                                                        value="{{ $data->beneficiary_voucher_value }}" required=""
                                                        data-parsley-required-message="Voucher Value is required">
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="form-label">Redeem From & To Date</label>
                                                    <div class="mg-b-20">
                                                        <div class="input-group">
                                                            <div class="input-group-prepend">
                                                                <div class="input-group-text">
                                                                    <i class="fe fe-calendar lh--9 op-6"></i>
                                                                </div>
                                                            </div><input class="form-control date_range_only"
                                                                type="text" name="beneficiaryFromTo"
                                                                value="{{ $data->beneficiary_from_to }}">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div> --}}

                                <div class="form-group">
                                    <div class="row row-sm">
                                        <div class="col-md-3">

                                        </div>
                                        <div class="col-md-9">
                                            <button class="btn ripple btn-success">
                                                @if (isset($data->id))
                                                    <i class="fe fe-edit"></i> Update
                                                @else
                                                    <i class="fe fe-check-circle"></i> Submit
                                                @endif
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('footerScripts')
    <script src="{{ URL::asset('js/referral-campaign.js') }}?{{ appVersion() }}"></script>
@endsection
