$(document).ready(function () {

    $('.add-row').trigger('click');

    var $schemeOption = $("<option/>", {
        value: 'All',
        text: 'All'
    });

    var $programOption = $("<option/>", {
        value: 'All',
        text: 'All'
    });


    var $scheme = $('#scheme');
    var $program = $('#program');
  
    $scheme.prepend($schemeOption);
    $program.prepend($programOption);


    $("#levels-table").on('click', '.delete-row', function () {
        $(this).closest('tr').remove();
        addSerialNumber('#levels-table tbody tr');
        var tableLenght = $('#levels-table tbody tr').length;
        addLevels(tableLenght);
    });

    $(document).on('change', '.common-on-change', function () {
        var id = $(this).attr('id');
        if (id == 'scheme') {
            getPrograms('get-programs-ajax', 'escalation-matrix');
        }
        else if (id == 'district') {
            getBlocks('get-block-ajax', 'escalation-matrix');
        }
        else if (id == 'block') {
            getSectors('get-sector-ajax', 'escalation-matrix');
        }
        else if (id == 'sector') {
            getAwcs('get-awc-ajax', 'escalation-matrix');
        }
    });

});


$('.add-row').click(function () {

    var tableLenght = $('#levels-table tbody tr').length;
    var clone = $('#cloneDiv').data('prototype');
    tableLenght = tableLenght + 1;
    clone = clone.replace("__index__", tableLenght);
    $("#levels-table tbody").append(clone);
    addSerialNumber('#levels-table tbody tr');
    addLevels(tableLenght);

});

function addLevels(tableLenght) {

    var fieldId = tableLenght;

    //multi level add
    $('.resolved_officer').find('option').remove();

    for (let index = 0; index < tableLenght; index++) {

        var level = index + 1;

        var data = {
            id: level,
            text: 'Level ' + level
        };

        var newOption = new Option(data.text, data.id, false, false);
        //single level add
        // $('#resolved_officer' + fieldId).append(newOption).trigger('change');
        //multi level add
        $('.resolved_officer').append(newOption).trigger('change');

    }
    //single level add
    // $('#resolved_officer' + fieldId).select2();
    //multi level add
    $('.resolved_officer').select2();

}
