$(document).ready(function () {
    window.Parsley.addValidator('checkemail', {
        validateString: function (value) {
            return $.ajax({
                url: 'common/check-user-email',
                method: "POST",
                data: {
                    email: value,
                    id: $('#userId').val()
                },
                dataType: "json",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).then(function (data) {
                // return true or false based on response
                return !data.exists;
            }).fail(function (xhr) {
                // Handle failure, usually returning false to signal validation failure
                return false;
            });
        },
        messages: {
            en: 'Email already exists.'
        }
    });
});
