$(function () {
    "use strict";

    // ______________ PAGE LOADING
    $("#global-loader").fadeOut("slow");

    //for hide toastr alert
    setTimeout(function () {
        $(".alert-tostr-custom").hide();
    }, 5000);

    $("#mainSidebarToggle").trigger("click");

    // ______________ Card
    const DIV_CARD = "div.card";

    // ______________ Function for remove card
    $(document).on("click", '[data-toggle="card-remove"]', function (e) {
        let $card = $(this).closest(DIV_CARD);
        $card.remove();
        e.preventDefault();
        return false;
    });

    // ______________ Functions for collapsed card
    $(document).on("click", '[data-toggle="card-collapse"]', function (e) {
        let $card = $(this).closest(DIV_CARD);
        $card.toggleClass("card-collapsed");
        e.preventDefault();
        return false;
    });

    // ______________ Card full screen
    $(document).on("click", '[data-toggle="card-fullscreen"]', function (e) {
        let $card = $(this).closest(DIV_CARD);
        $card.toggleClass("card-fullscreen").removeClass("card-collapsed");
        e.preventDefault();
        return false;
    });

    // ______________Main-navbar
    if (window.matchMedia("(min-width: 992px)").matches) {
        $(".main-navbar .active").removeClass("show");
        $(".main-header-menu .active").removeClass("show");
    }
    $(".main-header .dropdown > a").on("click", function (e) {
        e.preventDefault();
        $(this).parent().toggleClass("show");
        $(this).parent().siblings().removeClass("show");
    });
    $(".mobile-main-header .dropdown > a").on("click", function (e) {
        e.preventDefault();
        $(this).parent().toggleClass("show");
        $(this).parent().siblings().removeClass("show");
    });
    $(".main-navbar .with-sub").on("click", function (e) {
        e.preventDefault();
        $(this).parent().toggleClass("show");
        $(this).parent().siblings().removeClass("show");
    });
    $(".dropdown-menu .main-header-arrow").on("click", function (e) {
        e.preventDefault();
        $(this).closest(".dropdown").removeClass("show");
    });
    $("#mainNavShow").on("click", function (e) {
        e.preventDefault();
        $("body").toggleClass("main-navbar-show");
    });
    $("#mainContentLeftShow").on("click touch", function (e) {
        e.preventDefault();
        $("body").addClass("main-content-left-show");
    });
    $("#mainContentLeftHide").on("click touch", function (e) {
        e.preventDefault();
        $("body").removeClass("main-content-left-show");
    });
    $("#mainContentBodyHide").on("click touch", function (e) {
        e.preventDefault();
        $("body").removeClass("main-content-body-show");
    });
    $("body").append('<div class="main-navbar-backdrop"></div>');
    $(".main-navbar-backdrop").on("click touchstart", function () {
        $("body").removeClass("main-navbar-show");
    });

    // ______________Dropdown menu
    $(document).on("click touchstart", function (e) {
        e.stopPropagation();
        var dropTarg = $(e.target).closest(".main-header .dropdown").length;
        if (!dropTarg) {
            $(".main-header .dropdown").removeClass("show");
        }
        if (window.matchMedia("(min-width: 992px)").matches) {
            var navTarg = $(e.target).closest(".main-navbar .nav-item").length;
            if (!navTarg) {
                $(".main-navbar .show").removeClass("show");
            }
            var menuTarg = $(e.target).closest(
                ".main-header-menu .nav-item"
            ).length;
            if (!menuTarg) {
                $(".main-header-menu .show").removeClass("show");
            }
            if ($(e.target).hasClass("main-menu-sub-mega")) {
                $(".main-header-menu .show").removeClass("show");
            }
        } else {
            if (!$(e.target).closest("#mainMenuShow").length) {
                var hm = $(e.target).closest(".main-header-menu").length;
                if (!hm) {
                    $("body").removeClass("main-header-menu-show");
                }
            }
        }
    });

    // ______________MainMenuShow
    $("#mainMenuShow").on("click", function (e) {
        e.preventDefault();
        $("body").toggleClass("main-header-menu-show");
    });
    $(".main-header-menu .with-sub").on("click", function (e) {
        e.preventDefault();
        $(this).parent().toggleClass("show");
        $(this).parent().siblings().removeClass("show");
    });
    $(".main-header-menu-header .close").on("click", function (e) {
        e.preventDefault();
        $("body").removeClass("main-header-menu-show");
    });

    // ______________Tooltip
    $('[data-toggle="tooltip"]').tooltip();

    // ______________Toast
    $(".toast").toast();

    // ______________Back-top-button
    $(window).on("scroll", function (e) {
        if ($(this).scrollTop() > 0) {
            $("#back-to-top").fadeIn("slow");
        } else {
            $("#back-to-top").fadeOut("slow");
        }
    });
    $(document).on("click", "#back-to-top", function (e) {
        $("html, body").animate(
            {
                scrollTop: 0,
            },
            600
        );
        return false;
    });

    // ______________Full screen
    $(document).on("click", ".fullscreen-button", function toggleFullScreen() {
        $("html").addClass("fullscreen");
        if (
            (document.fullScreenElement !== undefined &&
                document.fullScreenElement === null) ||
            (document.msFullscreenElement !== undefined &&
                document.msFullscreenElement === null) ||
            (document.mozFullScreen !== undefined && !document.mozFullScreen) ||
            (document.webkitIsFullScreen !== undefined &&
                !document.webkitIsFullScreen)
        ) {
            if (document.documentElement.requestFullScreen) {
                document.documentElement.requestFullScreen();
            } else if (document.documentElement.mozRequestFullScreen) {
                document.documentElement.mozRequestFullScreen();
            } else if (document.documentElement.webkitRequestFullScreen) {
                document.documentElement.webkitRequestFullScreen(
                    Element.ALLOW_KEYBOARD_INPUT
                );
            } else if (document.documentElement.msRequestFullscreen) {
                document.documentElement.msRequestFullscreen();
            }
        } else {
            $("html").removeClass("fullscreen");
            if (document.cancelFullScreen) {
                document.cancelFullScreen();
            } else if (document.mozCancelFullScreen) {
                document.mozCancelFullScreen();
            } else if (document.webkitCancelFullScreen) {
                document.webkitCancelFullScreen();
            } else if (document.msExitFullscreen) {
                document.msExitFullscreen();
            }
        }
    });

    // ______________Cover Image
    $(".cover-image").each(function () {
        var attr = $(this).attr("data-image-src");
        if (typeof attr !== typeof undefined && attr !== false) {
            $(this).css("background", "url(" + attr + ") center center");
        }
    });

    // ______________Select2-Search
    $(".select2-no-search").select2({
        minimumResultsForSearch: Infinity,
        placeholder: "All categories",
        width: "100%",
    });

    // ______________Horizontal-menu Active Class
    function addActiveClass(element) {
        if (current === "") {
            if (element.attr("href").indexOf("#") !== -1) {
                element
                    .parents(".main-navbar .nav-item")
                    .last()
                    .removeClass("active");
                if (element.parents(".main-navbar .nav-sub").length) {
                    element
                        .parents(".main-navbar .nav-sub-item")
                        .last()
                        .removeClass("active");
                }
            }
        } else {
            if (element.attr("href").indexOf(current) !== -1) {
                element
                    .parents(".main-navbar .nav-item")
                    .last()
                    .addClass("active");
                if (element.parents(".main-navbar .nav-sub").length) {
                    element
                        .parents(".main-navbar .nav-sub-item")
                        .last()
                        .addClass("active");
                }
            }
        }
    }
    var current = location.pathname
        .split("/")
        .slice(-1)[0]
        .replace(/^\/|\/$/g, "");
    $(".main-navbar .nav li a").each(function () {
        var $this = $(this);
        addActiveClass($this);
    });

    // ______________ SWITCHER-toggle ______________//

    /*Theme Layouts*/
    //$('body').addClass('theme-style');
    //$('body').addClass('light-theme');
    //$('body').addClass('dark-theme');

    /*Header Styles*/
    //$('body').addClass('color-header');
    //$('body').addClass('header-dark');

    /*Horizontal-menu Styles*/
    //$('body').addClass('light-horizontal');
    //$('body').addClass('color-horizontal');

    /*Left-menu Styles*/
    //$('body').addClass('light-leftmenu');
    //$('body').addClass('color-leftmenu');

    /*Leftmenu Icon-Style*/
    //$('body').addClass('icon-style');
});

//custom scripts
function addSerialNumber(table) {
    $(table).each(function (index) {
        $(this)
            .find("td:nth-child(1)")
            .html(index + 1);
    });
}

function showToastr(msg, type) {
    $(".toastr-warning-msg").html(msg);
    $("#custom-toastr-alert").removeClass("d-none");
    $("#custom-toastr-alert").addClass(type);
    $("#custom-toastr-alert").show();
    hideToastr();
}

function hideToastr() {
    setTimeout(function () {
        $(".alert-tostr-custom").hide();
    }, 5000);
}

function darkMode() {
    var element = document.body;
    var updated = element.classList.toggle("dark-theme");

    var status = 0;

    if (updated) {
        status = 1;
    }
    var formData = {
        status: status,
    };
    var url = "update-theme";
    coreAjaxPost(formData, url);
}

function getAgents(url, screen = null) {
    formData = {
        branchId: $("#branch option:selected").val(),
    };
    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        dataType: "json",
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        success: function (response) {
            $("#agent").find("option").remove();

            $("#agent").append(
                `<option value="All" selected="selected">All</option>`
            );
            $.each(response, function (key, value) {
                $("#agent").append(
                    `<option value="${value.id}">${value.name}</option>`
                );
            });

            $("#agent").select2({
                placeholder: "All",
            });
        },
        error: function (jqXHR, exception) {},
    });
}

function getBranches(url, screen = null) {
    var formData = {
        clusterId: $("#cluster option:selected").val(),
    };
    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        dataType: "json",
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        success: function (response) {
            $("#branch").empty();
            $("#agent").empty();
            $("#branch").append(
                '<option value="All" selected="selected">All</option>'
            );
            $("#agent").append(
                '<option value="All" selected="selected">All</option>'
            );
            $.each(response, function (key, value) {
                $("#branch").append(
                    '<option value="' +
                        value.id +
                        '">' +
                        value.name +
                        "</option>"
                );
            });

            $("#branch").select2({
                placeholder: "All",
            });
            $("#agent").select2({
                placeholder: "All",
            });
        },
        error: function (jqXHR, exception) {
            // Handle error
            console.log(exception);
        },
    });
}

function coreAjaxPost(formData, url) {
    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        dataType: "json",
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        success: function (response) {
            hideLoader();
            if (response.status) {
                if (response.redirect) {
                    window.location.replace(response.redirect_url);
                }
                if (response.renderId) {
                    $(response.renderId).html(response.html);
                }
                if (response.tableId) {
                    if (response.export) {
                        $(response.tableId).DataTable({
                            dom: 'fBrtip<"clear">l',
                            columnDefs: [
                                {
                                    className: "dt-right",
                                    targets: [0],
                                },
                            ],
                            buttons: {
                                buttons: [
                                    {
                                        extend: "excel",
                                        className: "dataTable-excel",
                                    },
                                ],
                                lengthMenu: [
                                    [10, 25, 50, -1],
                                    [10, 25, 50, "All"],
                                ],
                            },
                        });
                    } else {
                        $(response.tableId).DataTable();
                    }
                }
            } else {
                showToastr(
                    "something went wrong, contact admin",
                    "alert-danger"
                );
            }
        },
        error: function (jqXHR, exception) {
            // console.log(jqXHR);
            // console.log(exception);
        },
    });
}

function showLoader() {
    $("#global-loader").show();
}

function hideLoader() {
    $("#global-loader").fadeOut("slow");
}

$("#date_range").daterangepicker({
    ranges: {
        Yesterday: [moment().subtract(1, "days"), moment().subtract(1, "days")],
        Today: [moment(), moment()],
        // Tomorrow: [moment().add(1, "days"), moment().add(1, "days")],
        "Last 7 Days": [moment().subtract(6, "days"), moment()],
        // "Next 7 Days": [moment(), moment().add(6, "days")],
        // "Next 30 Days": [moment(), moment().add(29, "days")],
        "Last Month": [
            moment().subtract(1, "month").startOf("month"),
            moment().subtract(1, "month").endOf("month"),
        ],
        "Last 2 Months": [
            moment().subtract(2, "month").startOf("month"),
            moment().subtract(1, "month").endOf("month"),
        ],
        "Last 3 Months": [
            moment().subtract(3, "month").startOf("month"),
            moment().subtract(1, "month").endOf("month"),
        ],
        "This Month": [moment().startOf("month"), moment().endOf("month")],
        // "Next Month": [
        // 	moment().add(1, "month").startOf("month"),
        // 	moment().add(1, "month").endOf("month"),
        // ],
    },
    startDate: moment(),
    endDate: moment(),
    autoApply: true,
    locale: {
        format: "DD/MM/YYYY",
    },
});

$(".date_range_only").daterangepicker({
    ranges: {},
    // startDate: moment(),
    // endDate: moment(),
    // autoApply: false,
    locale: {
        format: "DD/MM/YYYY",
    },
});

$(document).on("click", ".deleteRow", function (e) {
    e.preventDefault();
    var result = confirm("Are you sure you want to delete this?");
    if (result) {
        window.location.href = $(this).attr("href");
    }
});
