$(document).ready(function () {
    getDashboardData();
    $(document).on("change", ".common-on-change", function () {
        getDashboardData();
    });
});

function getDashboardData() {
    // $("#global-loader").show();
    var branch = $("#branch option:selected").val();
    var cluster = $("#cluster option:selected").val();
    var dateRange = $("#date_range").val();

    var url = "get-analytics-dashboard";

    formData = {
        branch: branch,
        dateRange: dateRange,
        cluster: cluster,
    };

    $.ajax({
        url: url,
        type: "POST",
        data: formData,
        dataType: "json",
        headers: {
            "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content"),
        },
        success: function (response) {
            $("#avgHandling").html(response.dashboardCounts.avgHandling);
            $("#agentsCount").html(response.dashboardCounts.agentsCount);
            $("#orgScore").html(response.dashboardCounts.orgScore + "%");
            $("#totalCalls").html(response.dashboardCounts.totalCalls);
            var previousScore = parseInt(
                response.dashboardCounts.orgScorePrevious
            );
            if (previousScore > 0) {
                var html =
                    '<span class="text-success" style="float: right;"><i class="fa fa-arrow-down" style="background: none;"></i>' +
                    previousScore +
                    "%</span>";
                $("#previousScore").html(html);
            } else if (previousScore < 0) {
                var html =
                    '<span class="text-danger" style="float: right;"><i class="fa fa-arrow-down" style="background: none;"></i>' +
                    previousScore +
                    "%</span>";
                $("#previousScore").html(html);
            } else {
                var html = '<p style="height:24px"></p>';
                $("#previousScore").html(html);
            }

            areaChart(response.graphData);
            $("#overviewHtml").html(response.overviewHtml);
            $("#branchAnalysisHtml").html(response.branchAnalysisHtml);
            $("#agent-table").html(response.agentsHtml);
            // $("#global-loader").fadeOut("slow");
        },
        error: function (jqXHR, exception) {},
    });
}

function areaChart(response) {
    Highcharts.chart("performance-trend", {
        chart: {
            type: "area",
            backgroundColor: "#0e0e23",
            style: {
                fontFamily: "sans-serif", // optional
                color: "#ffffff",
            },
        },
        title: {
            text: "Organization Performance Trend",
            style: {
                color: "#ffffff",
            },
        },
        xAxis: {
            categories: response.categories,
            tickmarkPlacement: "on",
            title: {
                enabled: false,
            },
            labels: {
                style: {
                    color: "#ffffff",
                },
            },
            lineColor: "#ffffff",
            tickColor: "#ffffff",
        },
        yAxis: {
            title: {
                text: "Performance (%)",
                style: {
                    color: "#ffffff",
                },
            },
            labels: {
                format: "{value}%",
                style: {
                    color: "#ffffff",
                },
            },
            gridLineColor: "#444444",
            lineColor: "#ffffff",
            tickColor: "#ffffff",
            max: 100,
        },
        tooltip: {
            split: true,
            valueSuffix: "%",
            style: {
                color: "#000000",
            },
        },
        legend: {
            itemStyle: {
                color: "#ffffff",
            },
        },
        plotOptions: {
            area: {
                stacking: "normal",
                lineColor: "#ff3399",
                lineWidth: 1,
                marker: {
                    lineWidth: 1,
                    lineColor: "#ff3399",
                },
            },
        },
        series: [
            {
                name: "Performance",
                data: response.data,
                color: {
                    linearGradient: [0, 0, 0, 300],
                    stops: [
                        [0, "rgba(255,105,180,0.8)"],
                        [1, "rgba(255,105,180,0)"],
                    ],
                },
            },
        ],
    });
}
