<?php

namespace App\View\Components;

use Illuminate\View\Component;

class YearsDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'years', $name = "years")
    {
        $this->selected = $selected ?? date('Y');
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;

        $years = [];
        $currentYear = date('Y');

        for ($i = 0; $i < 3; $i++) {
            $years[] = $currentYear - $i;
        }

        return view('components.years-drop-down', compact('years', 'id', 'label', 'selected', 'name'));
    }
}
