<?php

namespace App\View\Components;

use App\Models\User;
use Illuminate\View\Component;

class UsersDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'user', $name = "user")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;
        $users = User::select('id', 'name')->whereStatus(User::STATUS_ACTIVE)->where('user_type', [1, 3])->get();
        return view('components.users-drop-down', compact('users', 'id', 'label', 'selected', 'name'));
    }
}
