<?php

namespace App\View\Components;

use App\Models\CRM\Masters\TicketSource;
use App\Models\CRM\Masters\TicketType;
use Illuminate\View\Component;

class TicketTypeDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $labelText;
    private $label;

    public function __construct($selected = null, $label = true, $labelText = 'Ticket Type')
    {
        $this->selected = $selected;
        $this->labelText = $labelText;
        $this->label = $label;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $types = TicketType::select('id', 'name')->whereStatus(TicketType::STATUS_ACTIVE)->get();
        $selected = $this->selected;
        $labelText = $this->labelText;
        $label = $this->label;
        return view('components.ticket-type-drop-down', compact('types', 'selected', 'labelText', 'label'));
    }
}
