<?php

namespace App\View\Components;

use App\Models\CRM\Masters\TicketSource;
use Illuminate\View\Component;

class TicketSourceDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $labelText;
    private $label;

    public function __construct($selected = null, $label = true, $labelText = 'Ticket Source')
    {
        $this->selected = $selected;
        $this->labelText = $labelText;
        $this->label = $label;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $sources = TicketSource::select('id', 'name')->whereStatus(TicketSource::STATUS_ACTIVE)->get();
        $selected = $this->selected;
        $labelText = $this->labelText;
        $label = $this->label;
        return view('components.ticket-source-drop-down', compact('sources', 'selected', 'labelText', 'label'));
    }
}
