<?php

namespace App\View\Components;

use App\Models\CRM\Masters\TicketCategory;
use Illuminate\View\Component;

class TicketCategoryDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $labelText;
    private $label;

    public function __construct($selected = null, $label = true, $labelText = 'Ticket Category')
    {
        $this->selected = $selected;
        $this->labelText = $labelText;
        $this->label = $label;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $categories = TicketCategory::select('id', 'name')->whereStatus(TicketCategory::STATUS_ACTIVE)->get();
        $selected = $this->selected;
        $labelText = $this->labelText;
        $label = $this->label;
        return view('components.ticket-category-drop-down', compact('categories', 'selected', 'labelText', 'label'));
    }
}
