<?php

namespace App\View\Components;

use App\Models\Masters\CityMaster;
use App\Models\Masters\SectorMaster;
use Illuminate\View\Component;

class SectorDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'sector', $name = "sector")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;

        $sectors = SectorMaster::where('status', SectorMaster::STATUS_ACTIVE)->get();
        return view('components.sector-drop-down', compact('sectors', 'id', 'label', 'selected', 'name'));
    }
}
