<?php

namespace App\View\Components;

use App\Models\RoleMaster;
use Illuminate\View\Component;

class RoleDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;

    public function __construct($selected = null, $label = true)
    {
        $this->selected = $selected;
        $this->label = $label;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $roles = RoleMaster::getRoleActive()->get();
        $selected = $this->selected;
        $label = $this->label;
        return view('components.role-drop-down', compact('roles', 'selected', 'label'));
    }
}
