<?php

namespace App\View\Components;

use App\Models\ResolveReasons;
use Illuminate\View\Component;

class ResolveReasonsDropdown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'resolveReasons', $name = "resolveReasons")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;

        $reasons = ResolveReasons::whereStatus(ResolveReasons::STATUS_ACTIVE)->get();
        return view('components.resolve-reasons-dropdown', compact('reasons', 'id', 'label', 'selected', 'name'));
    }
}
