<?php

namespace App\View\Components;

use App\Models\CRM\Masters\RequestCategory;
use Illuminate\View\Component;

class RequestCategoryDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $labelText;
    private $label;

    public function __construct($selected = null, $label = true, $labelText = 'Search by Request Category')
    {
        $this->selected = $selected;
        $this->labelText = $labelText;
        $this->label = $label;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $categories = RequestCategory::select('id', 'name')->whereStatus(RequestCategory::STATUS_ACTIVE)->get();
        $selected = $this->selected;
        $labelText = $this->labelText;
        $label = $this->label;
        return view('components.request-category-drop-down', compact('categories', 'selected', 'labelText', 'label'));
    }
}
