<?php

namespace App\View\Components;

use App\Models\Masters\ProgramMaster;
use Illuminate\View\Component;

class ProgramDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'program', $name = "program")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;

        $programs = ProgramMaster::whereStatus(ProgramMaster::STATUS_ACTIVE)->get();
        return view('components.program-drop-down', compact('programs','id', 'label', 'selected', 'name'));
    }
}
