<?php

namespace App\View\Components;

use App\Models\CRM\Masters\CrmProducts;
use Illuminate\View\Component;

class ProductDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $labelText;
    private $label;

    public function __construct($selected = null, $label = true, $labelText = 'Product Inquired For')
    {
        $this->selected = $selected;
        $this->labelText = $labelText;
        $this->label = $label;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        // Fetch products with their associated brand names
        $products = CrmProducts::select('crm_products.id', 'crm_products.name as productName', 'crm_brands.name as brandName')
            ->leftJoin('crm_brands', 'crm_products.brand', '=', 'crm_brands.id')
            ->where('crm_products.status', CrmProducts::STATUS_ACTIVE)
            ->get();
    
        $selected = $this->selected;
        $labelText = $this->labelText;
        $label = $this->label;
    
        return view('components.product-drop-down', compact('products', 'selected', 'labelText', 'label'));
    }
}
