<?php

namespace App\View\Components;

use App\Models\CRM\Masters\PriorityType;
use App\Models\CRM\Masters\TicketType;
use Illuminate\View\Component;

class PriorityDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $labelText;
    private $label;

    public function __construct($selected = null, $label = true, $labelText = 'Priority')
    {
        $this->selected = $selected;
        $this->labelText = $labelText;
        $this->label = $label;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {
        $prioritys = PriorityType::select('id', 'name')->whereStatus(PriorityType::STATUS_ACTIVE)->get();
        $selected = $this->selected;
        $labelText = $this->labelText;
        $label = $this->label;
        return view('components.priority-drop-down', compact('prioritys', 'selected', 'labelText', 'label'));
    }
}
