<?php

namespace App\View\Components;

use App\Models\Masters\CityMaster;
use Illuminate\View\Component;

class DistrictDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'district', $name = "district")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;

        $districties = CityMaster::where('status', CityMaster::STATUS_ACTIVE)->get();
        return view('components.district-drop-down', compact('districties', 'id', 'label', 'selected', 'name'));
    }
}
