<?php

namespace App\View\Components;

use App\Models\Masters\BlockMaster;
use Illuminate\View\Component;

class BlockDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'block', $name = "block")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;

        $blocks = BlockMaster::where('status', BlockMaster::STATUS_ACTIVE)->get();
        return view('components.block-drop-down', compact('blocks', 'id', 'label', 'selected', 'name'));
    }
}
