<?php

namespace App\View\Components;

use App\Models\Masters\AwcMaster;
use Illuminate\View\Component;

class AwcDropDown extends Component
{
    /**
     * Create a new component instance.
     *
     * @return void
     */
    private $selected;
    private $label;
    private $id;
    private $name;

    public function __construct($selected = null, $label = true, $id = 'awc', $name = "awc")
    {
        $this->selected = $selected;
        $this->label = $label;
        $this->id = $id;
        $this->name = $name;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\Contracts\View\View|\Closure|string
     */
    public function render()
    {

        $id = $this->id;
        $label = $this->label;
        $selected = $this->selected;
        $name = $this->name;

        $awcList = AwcMaster::where('status', AwcMaster::STATUS_ACTIVE)->get();
        return view('components.awc-drop-down', compact('awcList', 'id', 'label', 'selected', 'name'));
    }
}
