<?php

namespace App\Services\Transactions;

use App\Models\CustomerCoupons;
use App\Models\ReferrerVouchers;
use App\Models\Sales;
use App\Services\CommonService;
use Carbon\Carbon;
use stdClass;
use Log;
use DB;

class SendCouponCodeService
{
    private $commonService;
    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    function sendCouponCode()
    {
        $this->getSalesData();
    }

    function getSalesData()
    {
        $sales = Sales::select('id', 'sap_ref_id', 'amount', 'mobile', 'customer_name', 'coupon_code')
            ->whereNull('whatsapp_notifi')
            ->get();
        $sales = $sales->groupBy('sap_ref_id');
        // dd($sales);
        foreach ($sales as $uniqueId => $groupedData) {

            if ($groupedData && $groupedData->count() > 0) {

                $param = new stdClass;
                $param->salesAmount = $groupedData->sum('amount');
                $param->salesId = $groupedData[0]->id;
                $param->cusMobile = $groupedData[0]->mobile;
                $param->cusName = $groupedData[0]->customer_name;
                $param->couponCode = $groupedData[0]->coupon_code;

                if (!$param->couponCode) {
                    $this->sendCouponCodeToCustomer($param);
                }
                $this->checkReferrerCouponCode($param);

                //update whatsapp notifi status
                DB::table('sales')->where('sap_ref_id', $uniqueId)->update(['whatsapp_notifi' => 1]);
            }
        }
    }

    function sendCouponCodeToCustomer($param)
    {

        $campaignValidity = Carbon::now()->addDays(21)->format('d/m/Y');

        if ($param->salesAmount >= 10000) {

            $coupon1 = CustomerCoupons::whereNull('sales_id')->where('coupon_amount', 1000)->first();
            $coupon2 = CustomerCoupons::whereNull('sales_id')->where('coupon_amount', 2000)->first();
            $coupon3 = CustomerCoupons::whereNull('sales_id')->where('coupon_amount', 3000)->first();

            if ($coupon1 && $coupon2 && $coupon3) {

                $coupon1->sales_id = $param->salesId;
                $save1 = $coupon1->save();
                $coupon2->sales_id = $param->salesId;
                $save2 = $coupon2->save();
                $coupon3->sales_id = $param->salesId;
                $save3 = $coupon3->save();

                if ($save1 && $save2 && $save3) {
                    $customerNumber = $this->commonService->formatMobileNo($param->cusMobile);
                    $waParam = new stdClass;
                    $waParam->mobile = $customerNumber;
                    $waParam->name = $param->cusName;
                    $waParam->voucherCode1 = $coupon1->coupon_code;
                    $waParam->voucherCode2 = $coupon2->coupon_code;
                    $waParam->voucherCode3 = $coupon3->coupon_code;
                    $waParam->validity = $campaignValidity;
                    $response = $this->sendReferralCoupon($waParam);
                    $decode = json_decode($response, true);
                    if (isset($decode['status']) && $decode['status'] == 'submitted') {
                        $messageId = isset($decode['messageId']) ? $decode['messageId'] : null;
                        $coupon1->message_id = $messageId;
                        $coupon1->save();
                        $coupon2->message_id = $messageId;
                        $coupon2->save();
                        $coupon3->message_id = $messageId;
                        $coupon3->save();
                    }
                }
            }
        }
    }

    function sendReferralCoupon($params)
    {

        $url = "https://api.gupshup.io/wa/api/v1/template/msg";

        $data = [
            'channel' => 'whatsapp',
            'source' => constants('GUPSHUP_WHATSAPP_SOURCE'),
            'destination' => '91' . $params->mobile,
            'src.name' => 'Xc8c5DTGK5YVdRiztBzmVuZo',
            'template' => json_encode([
                'id' => '51cadbac-9f80-4d5f-af1b-ab5ceb9f0e22',
                'params' => [
                    $params->name,
                    $params->validity,
                    $params->voucherCode1,
                    $params->voucherCode2,
                    $params->voucherCode3,
                ],
            ]),
            'message' => json_encode([
                'image' => [
                    'link' => 'https://assets.viveks.com/prom/pic-lnk/01JMEV9SEX3JJ370YGQDPW7K0D.jpeg'
                ],
                'type' => 'image',
            ]),
        ];

        $ch = curl_init($url);

        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Cache-Control: no-cache',
            'Content-Type: application/x-www-form-urlencoded',
            'apikey: ' . constants('GUPSHUP_API_KEY'),
        ]);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            Log::info('sendCouponCodeToCustomer : ' . json_encode(curl_error($ch)));
        } else {
            Log::info('sendCouponCodeToCustomer Response: ' . json_encode($response));
        }
        curl_close($ch);
        return $response;
    }

    function checkReferrerCouponCode($params)
    {
        if (isset($params->couponCode) && $params->couponCode) {

            $coupon = CustomerCoupons::select('customer_coupons.*', 'sales.customer_name', 'sales.mobile')
                ->join('sales', 'sales.id', 'customer_coupons.sales_id')
                ->where('customer_coupons.coupon_code', $params->couponCode)
                ->whereNotNull('customer_coupons.sales_id')
                ->first();

            if ($coupon) {

                $sendCoupon = false;
                if ($coupon->coupon_amount == 1000 && $params->salesAmount >= 10000) {
                    $sendCoupon = true;
                }
                if ($coupon->coupon_amount == 2000 && $params->salesAmount >= 20000) {
                    $sendCoupon = true;
                }
                if ($coupon->coupon_amount == 3000 && $params->salesAmount >= 30000) {
                    $sendCoupon = true;
                }

                if ($sendCoupon) {
                    //send coupon to customer logic here
                    $coupon->beneficiary_claimed = 1;
                    $coupon->referred_to = $params->salesId;
                    $coupon->save();

                    //update to referral coupon code
                    $referrerVoucher = ReferrerVouchers::whereNull('customer_coupon_id')->first();
                    if ($referrerVoucher) {
                        $referrerVoucher->customer_coupon_id = $coupon->id;
                        $referrerVoucher->save();

                        $customerNumber = $this->commonService->formatMobileNo($coupon->mobile);

                        $url = "https://api.gupshup.io/wa/api/v1/template/msg";

                        $data = [
                            'channel' => 'whatsapp',
                            'source' => constants('GUPSHUP_WHATSAPP_SOURCE'),
                            'destination' => '91' . $customerNumber,
                            'src.name' => 'Xc8c5DTGK5YVdRiztBzmVuZo',
                            'template' => json_encode([
                                'id' => '5598a191-35ec-4e9c-97d6-e28042f18859',
                                'params' => [
                                    $coupon->customer_name,
                                    $params->cusName,
                                    $referrerVoucher->voucher_code,
                                    '31/01/2025',
                                ],
                            ]),
                            "message" => json_encode([
                                "image" => [
                                    "id" => "524640447394413"
                                ],
                                "type" => "image"
                            ])
                        ];

                        $ch = curl_init($url);

                        curl_setopt($ch, CURLOPT_HTTPHEADER, [
                            'Cache-Control: no-cache',
                            'Content-Type: application/x-www-form-urlencoded',
                            'apikey: ' . constants('GUPSHUP_API_KEY'),
                        ]);
                        curl_setopt($ch, CURLOPT_POST, 1);
                        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

                        $response = curl_exec($ch);

                        if (curl_errno($ch)) {
                            Log::info('sendCouponCodeToCustomer : ' . json_encode(curl_error($ch)));
                        } else {
                            Log::info('sendCouponCodeToCustomer Response: ' . json_encode($response));
                        }
                        curl_close($ch);

                        $decode = json_decode($response, true);
                        if (isset($decode['status']) && $decode['status'] == 'submitted') {
                            $messageId = isset($decode['messageId']) ? $decode['messageId'] : null;
                            $referrerVoucher->message_id = $messageId;
                            $referrerVoucher->save();
                        }
                    } else {
                        Log::info('coupon code not found');
                    }
                }
            }
        } else {
            Log::info('coupon code not found in this request');
        }
    }
}
