<?php

namespace App\Services\Transactions;

use App\Models\Transactions\BeneficiaryImport;
use App\Models\Transactions\InterestedCallsTrans;
use App\Services\CommonService;
use Log;
use DB;

class InterestCallAllocationService
{

    private $commonService;

    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    function allocateData()
    {
        try {
            DB::beginTransaction();
            $this->startCallAllocation();
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            Log::info('interested call allocation error : ' . $e->getMessage());
        }
    }

    function getInterestedCalls()
    {
        $data = BeneficiaryImport::select('beneficiary_import.*', 'branch_master.name as branchName', 'agent_master.name as agentName')
            ->join('branch_master', 'branch_master.id', 'beneficiary_import.branch_id')
            ->join('agent_master', 'agent_master.id', 'beneficiary_import.agent_id')
            ->where('beneficiary_import.status', 3)
            ->whereIn('beneficiary_import.skip_reason', [12, 13, 15])
            ->whereNotNull('beneficiary_import.agent_id')
            ->orderBy('beneficiary_import.agent_id')
            ->get();
        return $data;
    }

    function startCallAllocation()
    {
        $interestedCalls = $this->getInterestedCalls();
        $groupCalls = $interestedCalls->groupBy('agent_id');
        foreach ($groupCalls as $empwise) {
            $inc = 0;
            foreach ($empwise as $calls) {
                $inc++;
                $calls->skip_reason = null;
                $calls->status = 1;
                if ($calls->save()) {
                    $trans = new InterestedCallsTrans();
                    $trans->ben_ref = $calls->id;
                    $trans->branch_id = $calls->branch_id;
                    $trans->agent_id = $calls->agent_id;
                    $trans->customer_name = $calls->customer_name;
                    $trans->mobile = $calls->mobile_number;
                    $trans->branch_name = $calls->branchName;
                    $trans->agent_name = $calls->agentName;
                    $trans->description = $calls->description;
                    $trans->invoice_date = $calls->invoice_date;
                    $trans->save();
                }
                if ($inc == 60) {
                    break;
                }
            }
        }
    }
}
