<?php

namespace App\Services\Transactions;

use App\Models\ApplicationSettings;
use App\Models\Masters\AgentMaster;
use App\Models\NumberingSystem;
use App\Models\Transactions\BeneficiaryImport;
use App\Models\Transactions\CallMapping;
use App\Models\Transactions\CallMappingItems;
use App\Services\CommonService;
use Carbon\Carbon;
use Log;
use DB;

class AutoCallAllocationService
{

    const CALL_NOT_ALLOCATED_DESIGNATION = [6];
    private $commonService;

    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    function allocateData()
    {
        try {
            DB::beginTransaction();
            $this->startCallAllocation();
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            Log::info('auto call allocation error : ' . $e->getMessage());
        }
    }

    function getUnassignedCalls($branchId)
    {
        $sql = BeneficiaryImport::select('id')
            ->where('status', BeneficiaryImport::STATUS_ACTIVE)
            ->where('source', BeneficiaryImport::SOURCE_TYPE_EXCEL)
            ->where('branch_id', $branchId)
            ->whereNull('agent_id');
        $data = $sql->get();
        return $data;
    }

    function startCallAllocation()
    {
        //get calls per user on per day
        // $settings = ApplicationSettings::where('setting_name', 'calls_per_user')->first();
        // $callsPerUser = isset($settings->setting_value) ? $settings->setting_value : 0;

        $agentList = AgentMaster::select('agent_master.id', 'agent_master.branch_id', 'designation_master.calls_per_user')
            ->join('designation_master', 'designation_master.id', 'agent_master.designation')
            ->where('agent_master.status', AgentMaster::STATUS_ACTIVE)
            // ->whereNotIn('agent_master.designation', self::CALL_NOT_ALLOCATED_DESIGNATION)
            ->get();

        $agentDataByBranch = $agentList->groupBy('branch_id');

        foreach ($agentDataByBranch as $branchId => $agents) {

            $unassignedCalls = $this->getUnassignedCalls($branchId);

            $agentCount = $agents->count();

            if ($unassignedCalls->count() > 0 && $agentCount > 0) {

                $perAgent = ceil($unassignedCalls->count() / $agentCount);
                $splitCustomer = $unassignedCalls->chunk($perAgent);

                $mappingID = null;

                foreach ($agents as $index => $agent) {

                    //get agents callback calls count
                    $callbackCount = BeneficiaryImport::where('agent_id', $agent->id)
                        ->where('callback_on', '>=', Carbon::now()->format('Y-m-d'))
                        ->where('callback_on', '<=', Carbon::now()->format('Y-m-d'))
                        ->where('source', BeneficiaryImport::SOURCE_TYPE_EXCEL)
                        ->count();

                    $pendingCalls = BeneficiaryImport::where('status', BeneficiaryImport::STATUS_ACTIVE)
                        ->where('branch_id', $branchId)
                        ->where('source', BeneficiaryImport::SOURCE_TYPE_EXCEL)
                        ->where('agent_id', $agent->id)
                        ->count();

                    $totalCallCount = ($agent->calls_per_user) - ((isset($callbackCount) ? $callbackCount : 0) + (isset($pendingCalls) ? $pendingCalls : 0));

                    if ($totalCallCount > 0) {

                        //add data to mapping table
                        if (is_null($mappingID)) {
                            $mappingNo = $this->commonService->generateUniqueScreenNumber(NumberingSystem::SCREEN_CALL_MAPPING);
                            $mapping = new CallMapping();
                            $mapping->mapping_no = $mappingNo;
                            $mapping->type = CallMapping::AUTO_MAPPING;
                            $mapping->branch_id = $branchId;
                            $mapping->save();
                            $mappingID = $mapping->id;
                        }

                        $assignDataUser = $splitCustomer->get($index);

                        if ($assignDataUser && $assignDataUser->isNotEmpty()) {
                            $agentCallsData = $assignDataUser->shift($totalCallCount);
                            $agentCalls = $agentCallsData ?? collect();
                            if (!$agentCalls instanceof \Illuminate\Support\Collection) {
                                $agentCalls = collect([$agentCalls]);
                            }
                            foreach ($agentCalls as $beneficiaryRow) {
                                //update agent id to row
                                $beneficiaryRow->agent_id = $agent->id;
                                $beneficiaryRow->created_at = Carbon::now();
                                $beneficiaryRow->save();

                                //add to mapping table unassigned leads
                                $mappingItem = new CallMappingItems();
                                $mappingItem->mapping_id = $mappingID;
                                $mappingItem->beneficiary_id = $beneficiaryRow->id;
                                $mappingItem->agent_id = $agent->id;
                                $mappingItem->save();
                            }
                        }
                    }
                }
            }
        }
    }
}
