<?php

namespace App\Services\Transactions;

use App\Models\Masters\AgentMaster;
use App\Models\NumberingSystem;
use App\Models\Transactions\BeneficiaryImport;
use App\Models\Transactions\CallMapping;
use App\Models\Transactions\CallMappingItems;
use App\Services\CommonService;
use Carbon\Carbon;
use Log;
use DB;
use stdClass;

class AutoCallAllocationFestiveService
{

    const BM_ROLE_DESIGNATION = [6];
    private $commonService;

    public function __construct(CommonService $commonService)
    {
        $this->commonService = $commonService;
    }

    function allocateData($type)
    {
        try {
            DB::beginTransaction();
            $this->type = $type;
            $this->startCallAllocation();
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            Log::info('auto call allocation error : ' . $e->getMessage());
        }
    }

    function getUnassignedCalls($params)
    {
        $sql = BeneficiaryImport::select('id')
            ->where('status', BeneficiaryImport::STATUS_ACTIVE)
            ->where('source', BeneficiaryImport::SOURCE_TYPE_EXCEL)
            ->where('branch_id', $params->branchId);
        if ($this->type == 1) {
            $sql->where('class', $params->classId);
        } else {
            $sql->whereNull('class');
        }

        $sql->whereNull('agent_id');
        $data = $sql->get();
        return $data;
    }

    function startCallAllocation()
    {

        $sql = AgentMaster::select('agent_master.id', 'agent_master.branch_id', 'designation_master.calls_per_user', 'agent_master.class', 'agent_master.designation', 'branch_master.calls_per_user as branch_calls_per_user')
            ->join('designation_master', 'designation_master.id', 'agent_master.designation')
            ->join('branch_master', 'branch_master.id', 'agent_master.branch_id')
            ->where('agent_master.status', AgentMaster::STATUS_ACTIVE);
        if ($this->type == 1) {
            $sql->whereNotIn('agent_master.designation', self::BM_ROLE_DESIGNATION);
        } else {
            $sql->whereIn('agent_master.designation', self::BM_ROLE_DESIGNATION);
        }
        $sql->where('branch_id', 1);
        $agentList = $sql->get();

        $agentDataByBranch = $agentList->groupBy('branch_id');
   
        foreach ($agentDataByBranch as $branchId => $agents) {

            $mappingID = null;

            $agentByClass = $agents->groupBy('class');

            foreach ($agentByClass as $classId => $classAgent) {

                $params = new stdClass;
                $params->branchId = $branchId;
                $params->classId = $classId;

                $unassignedCalls = $this->getUnassignedCalls($params);

                $agentCount = $classAgent->count();

                if ($unassignedCalls->count() > 0 && $agentCount > 0) {
              
                    $perAgent = ceil($unassignedCalls->count() / $agentCount);
                    $splitCustomer = $unassignedCalls->chunk($perAgent);

                    foreach ($classAgent as $index => $agent) {

                        //get agents callback calls count
                        $callbackCount = BeneficiaryImport::where('agent_id', $agent->id)
                            ->whereDate('callback_on', Carbon::now()->format('Y-m-d'))
                            ->where('source', BeneficiaryImport::SOURCE_TYPE_EXCEL)
                            ->count();

                        $pendingCalls = BeneficiaryImport::where('status', BeneficiaryImport::STATUS_ACTIVE)
                            ->where('branch_id', $branchId)
                            ->where('source', BeneficiaryImport::SOURCE_TYPE_EXCEL)
                            ->where('agent_id', $agent->id)
                            ->count();

                        if ($this->type == 1) {
                            $callsPerUser = $agent->calls_per_user;
                        } else {
                            $callsPerUser = $agent->branch_calls_per_user;
                        }

                        $totalCallCount = ($callsPerUser) - ((isset($callbackCount) ? $callbackCount : 0) + (isset($pendingCalls) ? $pendingCalls : 0));

                        if ($totalCallCount > 0) {

                            //add data to mapping table
                            if (is_null($mappingID)) {
                                $mappingNo = $this->commonService->generateUniqueScreenNumber(NumberingSystem::SCREEN_CALL_MAPPING);
                                $mapping = new CallMapping();
                                $mapping->mapping_no = $mappingNo;
                                $mapping->type = CallMapping::AUTO_MAPPING;
                                $mapping->branch_id = $branchId;
                                $mapping->save();
                                $mappingID = $mapping->id;
                            }

                            $assignDataUser = $splitCustomer->get($index);

                            if ($assignDataUser && $assignDataUser->isNotEmpty()) {
                                $agentCallsData = $assignDataUser->shift($totalCallCount);
                                $agentCalls = $agentCallsData ?? collect();
                                if (!$agentCalls instanceof \Illuminate\Support\Collection) {
                                    $agentCalls = collect([$agentCalls]);
                                }
                                foreach ($agentCalls as $beneficiaryRow) {
                                    //update agent id to row
                                    $beneficiaryRow->agent_id = $agent->id;
                                    $beneficiaryRow->created_at = Carbon::now();
                                    $beneficiaryRow->save();

                                    //add to mapping table unassigned leads
                                    $mappingItem = new CallMappingItems();
                                    $mappingItem->mapping_id = $mappingID;
                                    $mappingItem->beneficiary_id = $beneficiaryRow->id;
                                    $mappingItem->agent_id = $agent->id;
                                    $mappingItem->save();
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
