<?php

namespace App\Services;

use App\Imports\EscalationLevelImport;
use App\Imports\EscalationLevelThreeImport;
use App\Imports\EscalationLevelTwoImport;
use App\Models\Feedback;
use App\Models\FeedbackMasterFormField;
use App\Models\Masters\AwcMaster;
use App\Models\Masters\SectorMaster;
use App\Models\Transactions\BeneficiaryImport;
use DB;
use Log;
use Maatwebsite\Excel\Facades\Excel;

class TestService
{
    public function deleteDuplicateBeneficiary()
    {
        try {
            DB::beginTransaction();
            $data = DB::table('beneficiary_import')
                ->where('status', 1)
                ->select('mobile_number',
                    DB::raw('GROUP_CONCAT(id) as id')
                )
                ->groupBy('mobile_number')
                ->get();

            if ($data) {
                foreach ($data as $row) {
                    $ids = explode(',', $row->id);
                    if ($ids) {
                        $deleteId = array_shift($ids);
                        DB::table('beneficiary_import')->whereIn('id', $ids)->delete();
                    }
                }
            }

            DB::commit();
        } catch (\Exception$e) {
            DB::rollback();
            dd($e);
        }

    }

    public function addEscaltionLevels1()
    {
        try {
            DB::beginTransaction();
            $path = storage_path() . '/app/public/imports/level1/ariyalur.xlsx';
            Excel::import(new EscalationLevelImport, $path);
            echo 'imported successfully';
            DB::commit();
        } catch (\Exception$e) {
            DB::rollback();
            dd($e);
        }
    }

    public function addEscaltionLevel2()
    {
        try {
            DB::beginTransaction();
            $path = storage_path() . '/app/public/imports/level2/level2.xlsx';
            Excel::import(new EscalationLevelTwoImport, $path);
            echo 'imported successfully';
            DB::commit();
        } catch (\Exception$e) {
            DB::rollback();
            dd($e);
        }
    }

    public function addEscaltionLevel3()
    {
        try {
            DB::beginTransaction();
            $path = storage_path() . '/app/public/imports/level3/level3.xlsx';
            Excel::import(new EscalationLevelThreeImport, $path);
            echo 'imported successfully';
            DB::commit();
        } catch (\Exception$e) {
            DB::rollback();
            dd($e);
        }
    }

    public function getSectorId($sectorMaster, $row)
    {
        foreach ($sectorMaster as $sector) {
            if (formatString($sector->name) == formatString($row->sector)) {
                return $sector->id;
            }
        }
    }

    public function getAwcId($awcMaster, $row)
    {
        // foreach($awcMaster as $awc){
        //     if(formatString($awc->name) == formatString($row->awc)){
        //         return $awc->id;
        //     }
        // }
        $awc = AwcMaster::where('name', $row->awc)->whereStatus(AwcMaster::STATUS_ACTIVE)->first();
        if ($awc) {
            return $awc->id;
        }

    }

    public function updateSectorAndAwc()
    {
        try {
            DB::beginTransaction();
            $sectorMaster = SectorMaster::whereStatus(SectorMaster::STATUS_ACTIVE)->get();
            $awcMaster = AwcMaster::whereStatus(AwcMaster::STATUS_ACTIVE)->get();

            $beneficiary = BeneficiaryImport::groupBy('sector')->get();
            if ($beneficiary) {
                foreach ($beneficiary as $row) {
                    $sector = $this->getSectorId($sectorMaster, $row);
                    // $awc = $this->getAwcId($awcMaster, $row);
                    if (!$sector) {
                        Log::info($row->sector . ' Not found');
                    }
                    // if (!$awc) {
                    //     Log::info($row->awc . ' Not found');
                    // }

                    if ($sector) {
                        $update = [
                            'sector' => $sector,
                            // 'awc' => $awc,
                        ];
                        DB::table('beneficiary_import')->where('sector', $row->sector)->update($update);
                    }
                }
            }
            DB::commit();
        } catch (\Exception$e) {
            DB::rollback();
            dd($e);
        }
    }

    public function updateOthersValues()
    {
        try {
            DB::beginTransaction();
            $formFields = FeedbackMasterFormField::whereNotNull('others_values')->where('value', '')->get();
            foreach ($formFields as $list) {
                $update = FeedbackMasterFormField::find($list->id);
                if ($update) {
                    $update->value = $list->others_values;
                    $update->others_values = null;
                    $update->save();
                }
            }
            DB::commit();
        } catch (\Exception$e) {
            DB::rollback();
            dd($e);
        }
    }

    public function updateCalledUser()
    {
        try {
            DB::beginTransaction();
            $feedback = Feedback::whereStatus(Feedback::STATUS_ACTIVE)->get();
            if ($feedback) {
                foreach ($feedback as $feedbackRow) {
                    DB::table('beneficiary_import')->where('id', $feedbackRow->beneficiary_ref_id)->update(['updated_by' => $feedbackRow->created_by]);
                }
            }
            DB::commit();
        } catch (\Exception$e) {
            DB::rollback();
            dd($e);
        }

    }

}
