<?php

namespace App\Services\Reports;

use App\Models\Feedback;
use App\Utilities\ReportArguments;
use Carbon\Carbon;
use DB;
use Illuminate\Http\Request;

class ReportService
{
    public function processrequestFilters(Request $request)
    {
        $params = new ReportArguments();
        $params->scheme = isIssetValue($request, 'scheme');
        $params->program = isIssetValue($request, 'program');
        $params->district = isIssetValue($request, 'district');
        $params->dateRange = isIssetValue($request, 'dateRange');

        $splitDate = explode('-', $params->dateRange);

        if (isset($splitDate[0])) {
            $params->fromDate = Carbon::parse(trim($splitDate[0]));
        }
        if (isset($splitDate[1])) {
            $params->toDate = Carbon::parse(trim($splitDate[1]));
        }
        return $params;
    }

    public function coreFeedbackSql()
    {
        $sql = DB::table('beneficiary_import')
            ->join('feedback', 'feedback.beneficiary_ref_id', 'beneficiary_import.id')
            ->join('city_master', 'city_master.id', 'beneficiary_import.district_id')
            ->join('scheme_master', 'scheme_master.id', 'beneficiary_import.scheme_id')
            ->join('program_master', 'program_master.id', 'beneficiary_import.program_id')
            ->where('feedback.status', Feedback::STATUS_ACTIVE)
            ->whereNull('beneficiary_import.deleted_at');
        return $sql;
    }

    public function coreFeedbackSqlWithArgs($args)
    {
        $sql = $this->coreFeedbackSql();

        if ($args->scheme) {
            $sql->where('beneficiary_import.scheme_id', $args->scheme);
        }
        if ($args->program) {
            $sql->where('beneficiary_import.program_id', $args->program);
        }
        if ($args->district) {
            $sql->where('beneficiary_import.district_id', $args->district);
        }
        if ($args->fromDate && $args->toDate) {
            $sql->whereDate('feedback.created_at', '>=', $args->fromDate);
            $sql->whereDate('feedback.created_at', '<=', $args->toDate);
        }
        return $sql;
    }
}
