<?php

namespace App\Services\Reports;

use App\Models\CustomerCoupons;
use App\Models\Sales;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use DB;

class ReferralReportService
{
    private $reportService;
    private $excelExportService;

    public function __construct(ReportService $reportService, ExcelExportService $excelExportService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $fromDate = Carbon::parse($args->fromDate)->format('Y-m-d');
        $toDate = Carbon::parse($args->toDate)->format('Y-m-d');
        $sql = CustomerCoupons::select(
            'branch_master.name as branchName',
            'claimedBranch.name as claimedBranchName',
            'customer_coupons.coupon_code',
            'customer_coupons.coupon_amount',
            'referrer_vouchers.voucher_code',
            'referrer_vouchers.amount as referralAmount',
            'sales.mobile',
            'sales.customer_name',
            'sales.amount',
            'referrerSales.mobile as referredToMobile',
            'referrerSales.customer_name as referredToCustomerName',
            'referrerSales.amount as referredToAmount',
            DB::raw('DATE_FORMAT(sales.invoice_date, "%d-%m-%Y") as salesDate'),
            DB::raw('DATE_FORMAT(referrerSales.invoice_date, "%d-%m-%Y") as ReferredSalesDate'),
        )
            ->join('sales', 'sales.id', 'customer_coupons.sales_id')
            ->leftJoin('sales as referrerSales', 'referrerSales.id', 'customer_coupons.referred_to')
            ->leftJoin('referrer_vouchers', 'referrer_vouchers.customer_coupon_id', 'customer_coupons.id')
            ->leftJoin('branch_master', 'branch_master.id', 'sales.branch_id')
            ->leftJoin('branch_master as claimedBranch', 'claimedBranch.id', 'referrerSales.branch_id')
            ->where('sales.invoice_date', '>=', $fromDate)
            ->where('sales.invoice_date', '<=', $toDate);

        if ($args->branch && $args->branch != 'All') {
            $sql->where('sales.branch_id', $args->branch);
        }
        return $sql;
    }

    function getReportExcel(Request $request)
    {
        $sql = $this->getData($request);
        $data = $sql->get();
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'referral-report-excel';
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
