<?php

namespace App\Services\Reports;

use App\Models\Feedback;
use App\Models\Transactions\BeneficiaryImport;
use App\Services\Reports\ReportService;
use Illuminate\Http\Request;
use DB;

class OngoingCallsService
{
    private $reportService;
    public function __construct(ReportService $reportService)
    {
        $this->reportService = $reportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $sql = BeneficiaryImport::select(
            'cluster_master.name as clusterName',
            'branch_master.name as branchName',
            'agent_master.name as agentName',
            'beneficiary_import.customer_name',
            'beneficiary_import.mobile_number',
            'beneficiary_import.description',
            'beneficiary_import.invoice_date',
            'beneficiary_import.id',
        )
            ->join('branch_master', 'branch_master.id', 'beneficiary_import.branch_id')
            ->leftJoin('agent_master', 'agent_master.id', 'beneficiary_import.agent_id')
            ->leftJoin('cluster_branch_mapping', 'cluster_branch_mapping.branch_id', 'agent_master.branch_id')
            ->leftJoin('cluster_master', 'cluster_master.id', 'cluster_branch_mapping.cluster_id')
            ->where('beneficiary_import.call_status', 1);
        if ($args->branch && $args->branch != 'All') {
            $sql->where('beneficiary_import.branch_id', $args->branch);
        }
        if ($args->agent && $args->agent != 'All') {
            $sql->where('beneficiary_import.agent_id', $args->agent);
        }
        if ($args->cluster && $args->cluster != 'All') {
            $sql->where('cluster_master.id', $args->cluster);
        }
        return $sql;
    }

    function updateCallStatus(Request $request, $id = null)
    {
        $id = decrypt($id);
        if ($id) {
            $data = BeneficiaryImport::find($id);
            if ($data) {
                $data->call_status = null;
                $data->save();
                return true;
            }
        }
    }
}
