<?php

namespace App\Services\Reports;

use App\Models\AgentsLogin;
use App\Models\EnquiryHistory;
use App\Models\Feedback;
use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\BrandMaster;
use App\Services\DashboardService;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Illuminate\Http\Request;
use DB;
use stdClass;

class NoLoginNoCallService
{
    private $reportService;
    private $excelExportService;
    private $dashboardService;

    public function __construct(ReportService $reportService, ExcelExportService $excelExportService, DashboardService $dashboardService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
        $this->dashboardService = $dashboardService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);

        $sql = BranchMaster::select(
            'branch_master.id',
            'branch_master.name',
            DB::raw('COUNT(agent_master.id) as usersCount')
        )
            ->leftJoin('agent_master', 'agent_master.branch_id', 'branch_master.id')
            ->where('branch_master.status', BranchMaster::STATUS_ACTIVE)
            ->groupBy('branch_master.id');
        if ($args->branch && $args->branch != 'All') {
            $sql->where('agent_master.branch_id', $args->branch);
        }
        $branchMaster =   $sql->get();

        $agent = 'All';
        $branch = 'All';
        if ($args->branch > 0) {
            $branch = $args->branch;
        }
        $params = clone $args;
        $params->agent = $agent;
        $params->branch = $branch;
        $sql = $this->dashboardService->coreAgentCallDetails($params);
        $sql->select(
            'beneficiary_import.branch_id',
            DB::raw('COUNT(feedback.id) as dialledCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_status = 1 THEN feedback.id END) as connectedCalls'),
            DB::raw('COUNT(CASE WHEN feedback.call_status = 2 THEN feedback.id END) as notConnectedCalls')
        );
        $sql->groupBy('beneficiary_import.branch_id');
        $feedback = $sql->get();

        $assSql = $this->dashboardService->coreAgentAssignFollowDetails($params);
        $assigned = $assSql->select(
            'beneficiary_import.branch_id',
            DB::raw('COUNT(beneficiary_import.id) as totalCalls'),
        )
            ->groupBy('beneficiary_import.branch_id')
            ->get();

        $sqlAgent = AgentsLogin::select(
            'agent_master.branch_id',
            DB::raw('COUNT(DISTINCT(agents_login.agent_id)) as loginCount')
        )
            ->leftJoin('agent_master', 'agent_master.id', 'agents_login.agent_id')
            ->where('date', '>=', $args->fromDate)
            ->where('date', '<=', $args->toDate)
            ->groupBy('agent_master.branch_id');
        if ($args->branch && $args->branch != 'All') {
            $sql->where('agent_master.branch_id', $args->branch);
        }
        $agentLogin =   $sqlAgent->get();

        foreach ($branchMaster as $branch) {

            $branch->loginCount = 0;
            $branch->dialledCalls = 0;
            $branch->connectedCalls = 0;
            $branch->notConnectedCalls = 0;
            $branch->allocatedCalls = 0;

            foreach ($feedback as $feedbackRow) {
                if ($branch->id == $feedbackRow->branch_id) {
                    $branch->dialledCalls = $feedbackRow->dialledCalls;
                    $branch->connectedCalls = $feedbackRow->connectedCalls;
                    $branch->notConnectedCalls = $feedbackRow->notConnectedCalls;
                }
            }

            foreach ($assigned as $assignedRow) {
                if ($branch->id == $assignedRow->branch_id) {
                    $branch->allocatedCalls = $assignedRow->totalCalls;
                }
            }

            foreach ($agentLogin as $agentRow) {
                if ($branch->id == $agentRow->branch_id) {
                    $branch->loginCount = $agentRow->loginCount;
                }
            }
        }

        return $branchMaster;
    }

    function getReportExcel(Request $request)
    {
        $data = $this->getData($request);
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'nologin-nocalls-report-excel';
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
