<?php

namespace App\Services\Reports;

use App\Models\EnquiryHistory;
use Auth;
use App\Models\JustDialLeads;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Illuminate\Http\Request;
use DB;

class JustDialReportService
{
    private $reportService;
    private $excelExportService;

    public function __construct(ReportService $reportService, ExcelExportService $excelExportService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $sql = JustDialLeads::select(
            'branch_master.name as branchName',
            'just_dial_leads.*',
            'cluster_master.name as clusterName',
            DB::raw('CONCAT(DATE_FORMAT(just_dial_leads.date, "%d-%m-%Y"), " ", DATE_FORMAT(just_dial_leads.time, "%h:%i %p")) as dateTime'),
            DB::raw('
            CASE 
                WHEN just_dial_leads.status = 2 THEN "Converted"
                WHEN just_dial_leads.status = 3 THEN "Not Interested"
                ELSE "Pending"
            END as leadStatus
        '),
            DB::raw('
            CASE 
                WHEN just_dial_leads.read_status = 1 THEN "Seen"
                WHEN just_dial_leads.read_status = 2 THEN "Called"
                ELSE "Pending"
            END as readStatus
        ')
        )
            ->join('branch_master', 'branch_master.id', 'just_dial_leads.branch_id')
            ->where('just_dial_leads.date', '>=', $args->fromDate)
            ->where('just_dial_leads.date', '<=', $args->toDate)
            ->leftJoin('cluster_branch_mapping', 'cluster_branch_mapping.branch_id', 'branch_master.id')
            ->leftJoin('cluster_master', 'cluster_master.id', 'cluster_branch_mapping.cluster_id');
        if ($args->branch && $args->branch != 'All') {
            $sql->where('just_dial_leads.branch_id', $args->branch);
        }
        if ($args->cluster && $args->cluster != 'All') {
            $sql->where('cluster_master.id', $args->cluster);
        }
        $sql->groupBy('just_dial_leads.id');
        return $sql;
    }

    function updateLeadStatus(Request $request)
    {
        $id = decrypt($request->uniqueId);
        if ($request->formSubmitType == 'sap-enquiry') {
            $data = EnquiryHistory::find($id);
            if ($data) {
                $data->status = $request->status;
                $data->read_status_remarks = $request->remarks;
                $data->updated_by = Auth::user()->id;
                $data->save();
                return true;
            }
        } else if ($request->formSubmitType == 'just-dial') {
            $data = JustDialLeads::find($id);
            if ($data) {
                $data->status = $request->status;
                $data->remarks = $request->remarks;
                $data->updated_by = Auth::user()->id;
                $data->save();
                return true;
            }
        }
    }

    function getJustDialReportExcel(Request $request)
    {
        $sql = $this->getData($request);
        $data = $sql->get();
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'justdial-report-excel';
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        $params->clusterLabel = $this->reportService->getClusterById($args->cluster);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
