<?php

namespace App\Services\Reports;

use App\Models\CRMTickets;
use Auth;
use App\Models\JustDialLeads;
use App\Services\ExcelExportService;
use App\Services\Reports\ReportService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use DB;

class CRMReportService
{
    private $reportService;
    private $excelExportService;

    public function __construct(ReportService $reportService, ExcelExportService $excelExportService)
    {
        $this->reportService = $reportService;
        $this->excelExportService = $excelExportService;
    }

    public function getData(Request $request)
    {
        $args = $this->reportService->processrequestFilters($request);
        $fromDate = Carbon::parse($args->fromDate)->format('Y-m-d');
        $toDate = Carbon::parse($args->toDate)->format('Y-m-d');

        $sql = CRMTickets::select(
            'branch_master.name as branchName',
            'crm_tickets.*',
            'cluster_master.name as clusterName',
            DB::raw('DATE_FORMAT(crm_tickets.expected_date, "%d-%m-%Y") as expectedDate'),
            DB::raw('
            CASE 
                WHEN crm_tickets.read_status = 1 THEN "Seen"
                WHEN crm_tickets.read_status = 2 THEN "Called"
                ELSE "Pending"
            END as readStatus
        ')
        )
            ->join('branch_master', 'branch_master.id', 'crm_tickets.branch_id')
            ->where('crm_tickets.created_at', '>=', $fromDate . ' 00:00:00')
            ->where('crm_tickets.created_at', '<=', $toDate . ' 23:59:59')
            ->leftJoin('cluster_branch_mapping', 'cluster_branch_mapping.branch_id', 'branch_master.id')
            ->leftJoin('cluster_master', 'cluster_master.id', 'cluster_branch_mapping.cluster_id')
            ->groupBy('crm_tickets.id');
        if ($args->branch && $args->branch != 'All') {
            $sql->where('crm_tickets.branch_id', $args->branch);
        }
        if ($args->cluster && $args->cluster != 'All') {
            $sql->where('cluster_master.id', $args->cluster);
        }
        return $sql;
    }

    function getCRMReportExcel(Request $request)
    {
        $sql = $this->getData($request);
        $data = $sql->get();
        $args = $this->reportService->processrequestFilters($request);
        $params = clone $args;
        $params->type = 'crm-report-excel';
        $params->branchLabel = $this->reportService->getBranchById($args->branch);
        $params->clusterLabel = $this->reportService->getClusterById($args->cluster);
        return $this->excelExportService->exportExcel($params, $data);
    }
}
