<?php

namespace App\Services\Master;

use App\Models\Masters\BlockMaster;
use App\Models\Masters\SectorMaster;
use DB;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;

class SectorService
{

    public function __construct()
    {
    }

    public function getData()
    {
        $sql = DB::table('sector_master')
            ->join('city_master', 'city_master.id', 'sector_master.district_id')
            ->join('block_master', 'block_master.id', 'sector_master.block_id')
            ->select('city_master.name as district_name', 'block_master.name as block_name', 'sector_master.status', 'sector_master.id', 'sector_master.name', 'sector_master.code')
            ->whereNull('sector_master.deleted_at');
        return $sql;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = SectorMaster::find($id);
            $data->route = route('sector-master.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new SectorMaster();
            $data->route = route('sector-master.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('sector-master.index');
        $data->breadcrumbTitle = 'Sector';
        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $code = $request->has('code') ? $request->get('code') : '';
        $district = $request->has('district') ? $request->get('district') : '';
        $block = $request->has('block') ? $request->get('block') : '';
        $sectorId = $request->has('sectorId') ? $request->get('sectorId') : '';

        if ($sectorId) {
            $data = SectorMaster::find($sectorId);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new SectorMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->code = $code;
        $data->district_id = $district;
        $data->block_id = $block;
        $data->save();

        if ($data) {
            return true;
        }
    }
}
