<?php

namespace App\Services\Master;

use App\Models\Masters\ProgramMaster;
use App\Models\Masters\SchemeMaster;
use DB;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;

class ProgramService
{

    public function __construct()
    {

    }

    public function getData()
    {
        $data = DB::table('program_master')
            ->join('scheme_master', 'scheme_master.id', 'program_master.scheme_id')
            ->select('program_master.name', 'program_master.id', 'program_master.status', 'scheme_master.name as scheme','program_master.code')
            ->whereNull('program_master.deleted_at')
            ->where('scheme_master.status', SchemeMaster::STATUS_ACTIVE);
            // ->get();
        return $data;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = ProgramMaster::find($id);
            $data->route = route('program.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
        } else {
            $data = new ProgramMaster();
            $data->route = route('program.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('program.index');
        $data->breadcrumbTitle = 'Program';

        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $scheme = $request->has('scheme') ? $request->get('scheme') : '';
        $programId = $request->has('programId') ? $request->get('programId') : '';
        $code = $request->has('code') ? $request->get('code') : '';

        if ($programId) {
            $data = ProgramMaster::find($programId);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new ProgramMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->scheme_id = $scheme;
        $data->code = $code;
        $data->save();

        if ($data) {
            return true;
        }
    }

}
