<?php

namespace App\Services\Master;

use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchLeadsAssign;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\UserMaster;
use App\Models\User;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;
use DB;

class BranchService
{

    public function __construct() {}

    public function getData()
    {
        $data = BranchMaster::orderBy('id');
        return $data;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = BranchMaster::find($id);
            $data->route = route('branch.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
            $data->mapping = BranchLeadsAssign::where('branch_id', $id)->pluck('user_id')->toArray();
        } else {
            $data = new BranchMaster();
            $data->route = route('branch.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
            $data->mapping = [];
        }
        $data->breadcrumbAction = route('branch.index');
        $data->breadcrumbTitle = 'Branch';
        //get app users
        $appUsers = UserMaster::select('users.id', 'users.name', 'user_master.phone', 'user_master.id as tblUnique', 'branch_master.name as branchName', DB::raw('"appUsers" as type'))
            ->join('users', 'user_master.id', 'users.reference_id')
            ->join('branch_master', 'branch_master.id', 'user_master.branch_id')
            ->where('user_master.status', UserMaster::STATUS_ACTIVE)
            ->where('users.user_type', User::USER_TYPE_APP_USERS)
            ->get();

        //dont delete if we want agent also we can use below code

        $agents = AgentMaster::select('users.id', 'users.name', 'agent_master.phone', 'agent_master.id as tblUnique', 'branch_master.name as branchName', DB::raw('"agents" as type'))
            ->join('users', 'agent_master.id', 'users.reference_id')
            ->join('branch_master', 'branch_master.id', 'agent_master.branch_id')
            ->where('agent_master.status', AgentMaster::STATUS_ACTIVE)
            ->where('users.user_type', User::USER_TYPE_AGENT)
            ->get();
        $data->users = $appUsers->merge($agents);
        // $data->users = $appUsers;
        return $data;
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        $name = $request->has('name') ? $request->get('name') : '';
        $code = $request->has('code') ? $request->get('code') : '';
        $crmCode = $request->has('crmCode') ? $request->get('crmCode') : '';
        $sapCode = $request->has('sapCode') ? $request->get('sapCode') : '';
        $justDialCode = $request->has('justDialCode') ? $request->get('justDialCode') : '';
        $address = $request->has('address') ? $request->get('address') : '';
        $pincode = $request->has('pincode') ? $request->get('pincode') : '';
        $callsPerUser = $request->has('callsPerUser') ? $request->get('callsPerUser') : '';
        $excelCampaignCode = $request->has('excelCampaignCode') ? $request->get('excelCampaignCode') : '';
        $latitude = $request->has('latitude') ? $request->get('latitude') : '';
        $longitude = $request->has('longitude') ? $request->get('longitude') : '';
        $allowLoginDistance = $request->has('allowLoginDistance') ? $request->get('allowLoginDistance') : '0';

        if ($id) {
            $data = BranchMaster::find($id);
            $data->updated_by = Auth::user()->id;
        } else {
            $data = new BranchMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
        }
        $data->name = $name;
        $data->code = $code;
        $data->crm_code = $crmCode;
        $data->sap_code = $sapCode;
        $data->justdial_code = $justDialCode;
        $data->excel_campaign_code = $excelCampaignCode;
        $data->address = $address;
        $data->pincode = $pincode;
        $data->calls_per_user = $callsPerUser;
        $data->latitude = $latitude;
        $data->longitude = $longitude;
        $data->allow_login_distance = $allowLoginDistance;
        $data->save();

        if ($data) {
            if ($id) {
                BranchLeadsAssign::where('branch_id', $id)->delete();
            }
            $id = $data->id;
            if ($request->users) {
                foreach ($request->users as $value) {
                    $contact = new BranchLeadsAssign();
                    $contact->branch_id = $id;
                    $contact->user_id = $value;
                    $contact->save();
                }
            }
            // if ($request->leadname) {
            //     foreach ($request->leadname as $key => $value) {
            //         $contact = new BranchLeadsAssign();
            //         $contact->branch_id = $id;
            //         $contact->mobile = isset($request['leadmobile'][$key]) ? $request['leadmobile'][$key] : null;
            //         $contact->name = isset($value) ? $value : null;
            //         $contact->save();
            //     }
            // }

            return true;
        }
    }

    function show($id)
    {
        $data = BranchMaster::find($id);
        if ($data) {
            $data->mapping = BranchLeadsAssign::select('users.name', 'users.email')
                ->join('users', 'users.id', 'branch_leads_assign.user_id')
                ->where('branch_id', $id)
                ->get();
        }
        return $data;
    }
}
