<?php

namespace App\Services\Master;

use App\Models\Masters\AgentMapping;
use App\Models\Masters\AgentMaster;
use App\Models\Masters\BranchMaster;
use App\Models\Masters\BrandMaster;
use App\Models\Masters\DesignationMaster;
use App\Models\RoleMaster;
use App\Models\User;
use DB;
use Illuminate\Http\Request as HttpRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AgentService
{

    public function __construct() {}

    public function getData()
    {
        $data = AgentMaster::select('agent_master.id', 'agent_master.name', 'agent_master.status', 'agent_master.phone', 'designation_master.name as designation', 'brand_master.name as brand', 'branch_master.name as branchName', 'class_master.name as class')
            ->leftJoin('designation_master', 'designation_master.id', 'agent_master.designation')
            ->leftJoin('brand_master', 'brand_master.id', 'agent_master.brand')
            ->leftJoin('branch_master', 'branch_master.id', 'agent_master.branch_id')
            ->leftJoin('class_master', 'class_master.id', 'agent_master.class')
            ->orderBy('agent_master.id');
        return $data;
    }

    public function showData($id)
    {
        $data = DB::table('agent_master')
            ->leftJoin('designation_master', 'designation_master.id', 'agent_master.designation')
            ->leftJoin('role_master', 'role_master.id', 'agent_master.role')
            ->leftJoin('brand_master', 'brand_master.id', 'agent_master.brand')
            ->leftJoin('branch_master', 'branch_master.id', 'agent_master.branch_id')
            ->leftJoin('class_master', 'class_master.id', 'agent_master.class')
            ->where('agent_master.id', $id)
            ->select('agent_master.*', 'designation_master.name as designation', 'role_master.description as role', 'brand_master.name as brand', 'branch_master.name as branchName', 'class_master.name as class')
            ->first();
        return $data;
    }

    public function getMappingQuery($branchId = null)
    {
        $sql = DB::table('agent_mapping');
        $sql->join('agent_master', 'agent_master.id', 'agent_mapping.agent_id')
            ->join('branch_master', 'branch_master.id', 'agent_mapping.branch_id');

        if ($branchId) {
            $sql->where('agent_mapping.branch_id', $branchId);
            $sql->select('agent_master.name as agentName', 'agent_mapping.agent_id');
        } else {
            $sql->select('agent_mapping.branch_id as id', 'branch_master.name', 'agent_mapping.status');
        }

        return $sql;
    }

    public function getMappingData()
    {

        $agents = $this->getMappingQuery()->groupBy('agent_mapping.branch_id')->get();
        foreach ($agents as $agent) {
            $agentName = $this->getMappingQuery($agent->id)->pluck('agentName')->toArray();
            $agent->wrapText = implode(', ', $agentName);
        }
        return $agents;
    }

    public function isNew($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = AgentMaster::find($id);
            $data->route = route('agent-master.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
            //get user id
            $userData = User::where('email', $data->phone)->first();
            $data->userId = $userData->id;
        } else {
            $data = new AgentMaster();
            $data->route = route('agent-master.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('agent-master.index');
        $data->breadcrumbTitle = 'Agent';
        $data->designationList = DesignationMaster::whereStatus(DesignationMaster::STATUS_ACTIVE)->get();
        $data->brandList = BrandMaster::whereStatus(BrandMaster::STATUS_ACTIVE)->get();
        return $data;
    }

    public function isNewMapping($id = null)
    {
        if ($id) {
            $id = decrypt($id);
            $data = AgentMapping::where('branch_id', $id)->first();
            $data->route = route('agent-mapping.update', $id);
            $data->method = 'PUT';
            $data->breadcrumbName = 'Edit';
            $data->agents = $this->getMappingQuery($id)->pluck('agent_id')->toArray();
        } else {
            $data = new AgentMapping();
            $data->route = route('agent-mapping.store');
            $data->method = 'POST';
            $data->breadcrumbName = 'Create';
        }
        $data->breadcrumbAction = route('agent-mapping.index');
        $data->breadcrumbTitle = 'Agent Mapping';
        $data->branchList = BranchMaster::whereStatus(BranchMaster::STATUS_ACTIVE)->get();
        $data->agentList = AgentMaster::whereStatus(AgentMaster::STATUS_ACTIVE)->get();
        return $data;
    }

    public function saveMappingData(HttpRequest $request, $id = null)
    {

        $branch = $request->has('branch') ? $request->get('branch') : '';
        $agent = $request->has('agent') ? $request->get('agent') : '';

        AgentMapping::where('branch_id', $branch)->delete();

        if ($agent) {
            foreach ($agent as $value) {
                $mapping = new AgentMapping();
                $mapping->agent_id = $value;
                $mapping->branch_id = $branch;
                $mapping->created_by = Auth::user()->id;
                $mapping->updated_by = Auth::user()->id;
                $mapping->save();
            }
            return true;
        }
    }

    public function saveData(HttpRequest $request, $id = null)
    {
        // $files = [];

        // if ($request->file('attachments')) {

        //     foreach ($request->file('attachments') as $key => $file) {
        //         $fileName = time() . rand(1, 99) . '.' . $file->extension();
        //         $file->move(public_path('uploads/agent'), $fileName);
        //         array_push($files, $fileName);
        //     }
        // }

        $name = $request->has('name') ? $request->get('name') : '';
        $branch = $request->has('branch') ? $request->get('branch') : '';
        $phone = $request->has('phone') ? $request->get('phone') : '';
        $designation = $request->has('designation') ? $request->get('designation') : '';
        $password = $request->has('password') ? $request->get('password') : '';
        $role = RoleMaster::ROLE_AGENT;
        $agentId = $request->has('agentId') ? $request->get('agentId') : '';
        $userId = $request->has('userId') ? $request->get('userId') : '';
        $brand = $request->has('brand') ? $request->get('brand') : null;
        $class = $request->has('class') ? $request->get('class') : null;
        $crmLeadAssign = null;
        $sapLeadAssign = null;
        $vendorCampaignLeadAssign = null;

        if (isset($request->crmLeadAssign) &&  $request->crmLeadAssign == 'on') {
            $crmLeadAssign = 1;
        }
        if (isset($request->sapLeadAssign) &&  $request->sapLeadAssign == 'on') {
            $sapLeadAssign = 1;
        }
        if (isset($request->vendorCampaignLeadAssign) &&  $request->vendorCampaignLeadAssign == 'on') {
            $vendorCampaignLeadAssign = 1;
        }

        if ($agentId) {
            $data = AgentMaster::find($agentId);
            $data->updated_by = Auth::user()->id;
            $user = User::find($userId);
        } else {
            $data = new AgentMaster();
            $data->created_by = Auth::user()->id;
            $data->updated_by = Auth::user()->id;
            $user = new User();
            $user->password = Hash::make($password);
        }

        // if (count($files) > 0) {
        //     $data->attachments = implode(',', $files);
        // }

        $data->name = $name;
        $data->branch_id = $branch;
        $data->phone = $phone;
        $data->designation = $designation;
        $data->crm_lead_assign = $crmLeadAssign;
        $data->sap_lead_assign = $sapLeadAssign;
        $data->vendor_campaign_lead_assign = $vendorCampaignLeadAssign;
        $data->brand = $brand;
        $data->class = $class;
        $data->role = $role;
        $data->save();
        $lastId = $data->id;

        //save data to user table
        if (!$agentId) {
            $user->reference_id = $lastId;
        }

        $user->name = $name;
        $user->email = $phone;
        $user->role = $role;
        $user->user_type = User::USER_TYPE_AGENT;
        $user->save();

        if ($data) {
            return true;
        }
    }

    function getAgentsList(HttpRequest $request)
    {
        $agentList = [];
        $user = $request->user();
        if ($user->user_type == User::USER_TYPE_AGENT) {
            $agent = AgentMaster::find($request->user()->reference_id);
            if ($agent) {
                $agentList = AgentMaster::select('id', 'name')->where('branch_id', $agent->branch_id)->get();
            }
        }
        return $agentList;
    }
}
