<?php

namespace App\Services;

use App\Models\Masters\AwcMaster;
use App\Models\Masters\BlockMaster;
use App\Models\Masters\CityMaster;
use App\Models\Masters\EscalationMatrix;
use App\Models\Masters\ProgramMaster;
use App\Models\Masters\SchemeMaster;
use App\Models\Masters\SectorMaster;

class ImportService
{

    public function getEscalationData()
    {
        $escalation = EscalationMatrix::whereStatus(EscalationMatrix::STATUS_ACTIVE)->get();
        return $escalation;
    }

    public function createDistrict($args, $name)
    {
        $city = new CityMaster();
        $city->state = $args->state;
        $city->name = $name;
        $city->save();
        return $city->id;
    }

    public function createBlock($args, $name)
    {
        $block = new BlockMaster();
        $block->district_id = $args->district;
        $block->name = $name;
        $block->save();
        return $block->id;
    }

    public function createAwc($args, $name)
    {
        $awc = new AwcMaster();
        $awc->block_id = $args->block;
        $awc->district_id = $args->district;
        $awc->sector_id = $args->sector;
        $awc->name = $name;
        $awc->save();
        return $awc->id;
    }

    public function createSector($args, $name)
    {
        $awc = new SectorMaster();
        $awc->block_id = $args->block;
        $awc->district_id = $args->district;
        $awc->name = $name;
        $awc->save();
        return $awc->id;
    }

    public function getDistrictByName($args, $name)
    {

        $city = CityMaster::where('name', formatString($name))
            ->whereStatus(CityMaster::STATUS_ACTIVE)
            ->first();
        if ($city) {
            return $city->id;
        }

        if ($args->create) {
            return $this->createDistrict($args, $name);
        }

    }

    public function getBlockByName($args, $name)
    {
        $block = BlockMaster::where('district_id', $args->district)
            ->where('name', formatString($name))
            ->whereStatus(BlockMaster::STATUS_ACTIVE)
            ->first();
        if ($block) {
            return $block->id;
        }
        if ($args->create) {
            return $this->createBlock($args, $name);
        }
    }

    public function getAwcByName($args, $name)
    {
        $awc = AwcMaster::where('sector_id', $args->sector)
            ->where('name', formatString($name))
            ->whereStatus(AwcMaster::STATUS_ACTIVE)
            ->first();
        if ($awc) {
            return $awc->id;
        }
        return $this->createAwc($args, $name);
    }

    public function getSectorByName($args, $name)
    {
        $sector = SectorMaster::where('block_id', $args->block)
            ->where('name', formatString($name))
            ->whereStatus(SectorMaster::STATUS_ACTIVE)
            ->first();
        if ($sector) {
            return $sector->id;
        }
        return $this->createSector($args, $name);
    }

    public function getSchemes()
    {
        $scheme = SchemeMaster::whereStatus(SchemeMaster::STATUS_ACTIVE)->select('id', 'name')->get();
        return $scheme;
    }

    public function getPrograms()
    {
        $program = ProgramMaster::whereStatus(ProgramMaster::STATUS_ACTIVE)->select('id', 'name')->get();
        return $program;
    }

}
