<?php

namespace App\Services;

use App\Models\Sales;
use App\Models\Transactions\BeneficiaryImport;
use Carbon\Carbon;
use Log;
use DB;

class HappyCallsService
{
    const FETCH_DURATION_DAYS = 7;
    public function __construct() {}

    function fetchData()
    {
        try {
            DB::beginTransaction();
            $this->copySalesDataToCallerTable();
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            Log::info('happy calls fetching error : ' . $e->getMessage());
        }
    }

    function copySalesDataToCallerTable()
    {
        $date = Carbon::now()->subDays(self::FETCH_DURATION_DAYS)->format('Y-m-d');
        $sales = Sales::select('sales.customer_name', 'sales.mobile', 'sales.branch_id', 'sales.product', 'sales.agent_id', 'agent_master.branch_id', 'sales.invoice_date', 'sales.id')
            ->join('agent_master', 'agent_master.id', 'sales.agent_id')
            ->where('sales.invoice_date', '<=', $date)
            ->whereNull('sales.happy_call')
            ->get();
        if ($sales) {
            foreach ($sales as $row) {
                $leads = new BeneficiaryImport();
                $leads->branch_id = $row->branch_id;
                $leads->customer_name = $row->customer_name;
                $leads->mobile_number = $row->mobile;
                $leads->invoice_date = $row->invoice_date;
                $leads->description = $row->product;
                $leads->import_type = 1;
                $leads->agent_id = $row->agent_id;
                $leads->source = BeneficiaryImport::SOURCE_TYPE_HAPPY_CALLS;
                $leads->happy_calls_id = $row->id;
                $leads->save();

                //update data to sales table
                Sales::where('id', $row->id)->update(['happy_call' => 1]);
            }
        }
    }
}
